/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.collect.action;

import com.iteaj.iboot.msn.iot.collect.CollectException;
import com.iteaj.iboot.msn.iot.dto.CollectTaskDto;
import com.iteaj.iboot.msn.iot.entity.CollectDetail;
import com.iteaj.iboot.msn.iot.entity.Signal;
import java.util.function.Consumer;
import org.springframework.util.StringUtils;

public abstract class CollectAction {
    public abstract String getName();

    public abstract String getDesc();

    public void validate(Signal signal) throws CollectException {
        String address = signal.getAddress();
        if (!StringUtils.hasText((String)address)) {
            throw new CollectException("\u70b9\u4f4d[" + signal.getName() + "]\u6ca1\u6709\u6307\u5b9a\u5730\u5740");
        }
    }

    public void validate(CollectDetail detail) throws CollectException {
        if (detail == null || detail.getDevice() == null) {
            throw new CollectException("\u53c2\u6570[device]\u4e0d\u80fd\u4e3anull");
        }
        if (!StringUtils.hasText((String)detail.getDevice().getDeviceSn())) {
            throw new CollectException("\u672a\u6307\u5b9a\u8bbe\u5907\u7f16\u53f7");
        }
    }

    public void exec(CollectTaskDto taskDto, CollectDetail detail, Signal signal, Consumer<String> call) throws CollectException {
        this.doExec(taskDto, detail, signal, call);
    }

    protected abstract void doExec(CollectTaskDto var1, CollectDetail var2, Signal var3, Consumer<String> var4);
}

