/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.debug;

import com.iteaj.iboot.msn.iot.debug.DebugHandle;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;

public class DebugHandleFactory
implements InitializingBean {
    private List<DebugHandle> debugHandles;
    private Map<String, DebugHandle> handleMap = new HashMap(8);

    public DebugHandleFactory(List<DebugHandle> debugHandles) {
        this.debugHandles = debugHandles;
    }

    public Optional<DebugHandle> getHandle(String type) {
        return Optional.ofNullable(this.handleMap.get(type));
    }

    public void afterPropertiesSet() throws Exception {
        if (!CollectionUtils.isEmpty((Collection)this.debugHandles)) {
            this.handleMap = this.debugHandles.stream().collect(Collectors.toMap(item -> item.type(), item -> item));
        }
    }
}

