/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.rtu;

import com.iteaj.iboot.msn.iot.rtu.ModbusRtuClientCommonProtocol;
import com.iteaj.iboot.msn.iot.rtu.ModbusRtuMessageBuilder;
import com.iteaj.iot.Protocol;
import com.iteaj.iot.ProtocolException;
import com.iteaj.iot.ProtocolHandle;
import com.iteaj.iot.client.ClientConnectProperties;
import com.iteaj.iot.client.IotClient;
import com.iteaj.iot.client.SocketClient;
import com.iteaj.iot.client.protocol.ClientInitiativeSyncProtocol;
import com.iteaj.iot.consts.ExecStatus;
import com.iteaj.iot.modbus.ModbusCommonProtocol;
import com.iteaj.iot.modbus.ModbusProtocolException;
import com.iteaj.iot.modbus.ModbusUtil;
import com.iteaj.iot.modbus.Payload;
import com.iteaj.iot.modbus.ReadPayload;
import com.iteaj.iot.modbus.RealCoilPayload;
import com.iteaj.iot.modbus.WritePayload;
import com.iteaj.iot.modbus.client.rtu.ModbusRtuClientMessage;
import com.iteaj.iot.modbus.consts.ModbusCode;
import com.iteaj.iot.modbus.consts.ModbusCoilStatus;
import com.iteaj.iot.modbus.server.rtu.ModbusRtuBody;
import com.iteaj.iot.modbus.server.rtu.ModbusRtuHeader;
import com.iteaj.iot.serial.SerialClient;
import com.iteaj.iot.serial.SerialComponent;
import com.iteaj.iot.serial.SerialConnectProperties;
import com.iteaj.iot.utils.ByteUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.springframework.util.ObjectUtils;

public class ModbusRtuClientCommonProtocol
extends ClientInitiativeSyncProtocol<ModbusRtuClientMessage>
implements ModbusCommonProtocol {
    private int start;
    private ModbusCode code;
    private Payload payload;

    protected ModbusRtuClientCommonProtocol(ModbusRtuClientMessage message) {
        this.requestMessage = message;
        this.code = message.getBody().getCode();
        this.start = message.getBody().getStart();
    }

    protected ModbusRtuClientCommonProtocol(ModbusCode code, ModbusRtuClientMessage message) {
        this.code = code;
        this.requestMessage = message;
    }

    protected ModbusRtuClientCommonProtocol(int start, ModbusCode code, ModbusRtuClientMessage message) {
        this.code = code;
        this.start = start;
        this.requestMessage = message;
    }

    protected ModbusRtuClientMessage doBuildRequestMessage() {
        if (((ModbusRtuClientMessage)this.requestMessage).getMessage() == null) {
            ((ModbusRtuClientMessage)this.requestMessage).writeBuild();
        }
        return (ModbusRtuClientMessage)this.requestMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendRequest() throws ProtocolException {
        this.buildRequestMessage();
        IotClient iotClient = this.getRtuClient();
        if (iotClient instanceof SerialClient) {
            IotClient iotClient2 = iotClient;
            synchronized (iotClient2) {
                if (!((SerialClient)iotClient).isOpen() && !((SerialClient)iotClient).open()) {
                    throw new ProtocolException("\u6253\u5f00\u4e32\u53e3\u5f02\u5e38[" + this.getClientKey() + "]");
                }
                int available = ((SerialClient)iotClient).bytesAvailable();
                if (available > 0) {
                    byte[] bytes = new byte[available];
                    ((SerialClient)iotClient).read(bytes);
                }
                byte[] message = ((ModbusRtuClientMessage)this.requestMessage()).getMessage();
                ((SerialClient)iotClient).writeOfSync(message, message.length);
                long timeout = this.getTimeout();
                long currentTimeMillis = System.currentTimeMillis();
                ByteBuf buffer = Unpooled.buffer((int)256);
                while (this.readBytes((SerialClient)iotClient, buffer, this.protocolType()) != -1) {
                    if (System.currentTimeMillis() - currentTimeMillis <= timeout) continue;
                    this.setExecStatus(ExecStatus.timeout);
                    break;
                }
                if (this.getExecStatus() == ExecStatus.success && buffer.readableBytes() > 0) {
                    byte[] bytes = new byte[buffer.readableBytes()];
                    buffer.readBytes(bytes);
                    buffer.release();
                    ModbusRtuHeader rtuHeader = ModbusRtuHeader.buildResponseHeader((byte[])bytes);
                    ModbusRtuBody modbusRtuBody = ModbusRtuBody.buildResponseBody((byte[])bytes);
                    this.responseMessage = new ModbusRtuClientMessage(rtuHeader, modbusRtuBody);
                    ((ModbusRtuClientMessage)this.responseMessage).setMessage(bytes);
                }
            }
            this.buildResponseMessage();
            ProtocolHandle protocolHandle = this.getProtocolHandle();
            if (protocolHandle != null) {
                protocolHandle.handle((Protocol)this);
            }
        }
    }

    public IotClient getRtuClient() {
        ClientConnectProperties clientKey = this.getClientKey();
        if (clientKey instanceof SerialConnectProperties) {
            SerialComponent instance = SerialComponent.instance();
            SerialClient client = instance.getClient((Object)clientKey);
            if (client == null) {
                client = instance.createNewClient(clientKey);
                client.init(null);
                if (client.open()) {
                    instance.addClient((Object)clientKey, (IotClient)client);
                } else {
                    throw new ProtocolException("\u5f00\u542f\u4e32\u53e3\u5931\u8d25[" + clientKey + "]");
                }
            }
            return client;
        }
        throw new ProtocolException("\u83b7\u53d6\u5ba2\u6237\u7aef\u5931\u8d25");
    }

    protected int readBytes(SerialClient client, ByteBuf buffer, ModbusCode code) {
        byte[] message;
        if (client.bytesAvailable() == 0) {
            return 0;
        }
        int readableBytes = buffer.readableBytes();
        if (readableBytes == 0) {
            message = new byte[2];
            client.readOfSync(message, (int)this.getTimeout());
            buffer.writeBytes(message);
            int respCode = message[1] & 0xFF;
            if (respCode > 128) {
                message = new byte[3];
                client.readOfSync(message, (int)this.getTimeout());
                buffer.writeBytes(message);
                return -1;
            }
        }
        if (code.getCode() >= 5) {
            if (readableBytes < 8) {
                message = new byte[6];
                client.readOfSync(message, (int)this.getTimeout());
                buffer.writeBytes(message);
            }
            return -1;
        }
        if (readableBytes > 2) {
            buffer.readerIndex(2);
            int length = buffer.readByte() & 0xFF;
            byte[] message2 = new byte[length + 2];
            client.readOfSync(message2, (int)this.getTimeout());
            buffer.writeBytes(message2).resetReaderIndex();
            return -1;
        }
        message = new byte[1];
        client.readOfSync(message, (int)this.getTimeout());
        buffer.writeBytes(message);
        return message.length;
    }

    public SocketClient getIotClient() {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301,\u8bf7\u7528getRtuClient()\u66ff\u4ee3");
    }

    public void doBuildResponseMessage(ModbusRtuClientMessage responseMessage) {
        if (this.getExecStatus() == ExecStatus.success) {
            ModbusCode code = responseMessage.getBody().getCode();
            byte[] content = responseMessage.getBody().getContent();
            if (responseMessage.getBody().getErrCode() != null) {
                return;
            }
            switch (1.$SwitchMap$com$iteaj$iot$modbus$consts$ModbusCode[code.ordinal()]) {
                case 1: 
                case 2: {
                    this.payload = new RealCoilPayload(this.start, content);
                    break;
                }
                case 3: 
                case 4: {
                    this.payload = new ReadPayload(content, this.start);
                    break;
                }
                default: {
                    this.payload = WritePayload.getInstance();
                }
            }
        }
    }

    public static ModbusRtuClientCommonProtocol buildRead01(int device, int start, int num) {
        ModbusRtuClientMessage message = ModbusRtuMessageBuilder.buildRead01Message((int)device, (int)start, (int)num);
        return new ModbusRtuClientCommonProtocol(num, ModbusCode.Read01, message);
    }

    public static ModbusRtuClientCommonProtocol buildRead02(int device, int start, int num) {
        ModbusRtuClientMessage message = ModbusRtuMessageBuilder.buildRead02Message((int)device, (int)start, (int)num);
        return new ModbusRtuClientCommonProtocol(num, ModbusCode.Read02, message);
    }

    public static ModbusRtuClientCommonProtocol buildRead03(int device, int start, int num) {
        ModbusRtuClientMessage message = ModbusRtuMessageBuilder.buildRead03Message((int)device, (int)start, (int)num);
        return new ModbusRtuClientCommonProtocol(start, ModbusCode.Read03, message);
    }

    public static ModbusRtuClientCommonProtocol buildRead04(int device, int start, int num) {
        ModbusRtuClientMessage message = ModbusRtuMessageBuilder.buildRead04Message((int)device, (int)start, (int)num);
        return new ModbusRtuClientCommonProtocol(start, ModbusCode.Read04, message);
    }

    public static ModbusRtuClientCommonProtocol buildWrite05(int device, int start, ModbusCoilStatus status) {
        ModbusRtuClientMessage message = ModbusRtuMessageBuilder.buildWrite05Message((int)device, (int)start, (ModbusCoilStatus)status);
        return new ModbusRtuClientCommonProtocol(ModbusCode.Write05, message);
    }

    public static ModbusRtuClientCommonProtocol buildWrite06(int device, int start, byte[] write) {
        ModbusRtuClientMessage message = ModbusRtuMessageBuilder.buildWrite06Message((int)device, (int)start, (byte[])write);
        return new ModbusRtuClientCommonProtocol(ModbusCode.Write06, message);
    }

    public static ModbusRtuClientCommonProtocol buildWrite06(int device, int start, short value) {
        byte[] write = ByteUtil.getBytesOfReverse((short)value);
        ModbusRtuClientMessage message = ModbusRtuMessageBuilder.buildWrite06Message((int)device, (int)start, (byte[])write);
        return new ModbusRtuClientCommonProtocol(ModbusCode.Write06, message);
    }

    public static ModbusRtuClientCommonProtocol buildWrite0F(int device, int start, byte[] write) {
        ModbusRtuClientMessage message = ModbusRtuMessageBuilder.buildWrite0FMessage((int)device, (int)start, (byte[])write);
        return new ModbusRtuClientCommonProtocol(ModbusCode.Write0F, message);
    }

    public static ModbusRtuClientCommonProtocol buildWrite10(int device, int start, int num, byte[] write) {
        ModbusRtuClientMessage message = ModbusRtuMessageBuilder.buildWrite10Message((int)device, (int)start, (int)num, (byte[])write);
        return new ModbusRtuClientCommonProtocol(ModbusCode.Write10, message);
    }

    public static ModbusRtuClientCommonProtocol buildWrite10(int device, int start, Object ... args) {
        if (ObjectUtils.isEmpty((Object[])args)) {
            throw new ModbusProtocolException("\u672a\u6307\u5b9a\u8981\u5199\u7684\u5185\u5bb9", (Object)ModbusCode.Write10);
        }
        ModbusUtil.Write10Build write10Build = ModbusUtil.write10Build((Object[])args);
        ModbusRtuClientMessage message = ModbusRtuMessageBuilder.buildWrite10Message((int)device, (int)start, (int)write10Build.num, (byte[])write10Build.message);
        return new ModbusRtuClientCommonProtocol(ModbusCode.Write10, message);
    }

    public static ModbusRtuClientCommonProtocol build(byte[] message) {
        return new ModbusRtuClientCommonProtocol(new ModbusRtuClientMessage(message));
    }

    public Payload getPayload() {
        return this.payload;
    }

    public ModbusCode protocolType() {
        return this.code;
    }
}

