/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.spi.auth.handle;

import com.iteaj.framework.autoconfigure.FrameworkProperties;
import com.iteaj.framework.exception.FrameworkException;
import com.iteaj.framework.spi.auth.WebAuthAction;
import com.iteaj.framework.spi.auth.WebAuthHandler;
import com.iteaj.framework.web.WebUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DefaultAuthHandler
implements WebAuthHandler,
InitializingBean {
    private List<WebAuthAction> actions;
    private FrameworkProperties config;
    private Map<String, WebAuthAction> actionMap;
    protected static Logger logger = LoggerFactory.getLogger(WebAuthHandler.class);

    public DefaultAuthHandler(List<WebAuthAction> actions) {
        this.actions = actions;
        try {
            this.actionMap = actions.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        }
        catch (Exception e) {
            throw new FrameworkException("actions\u5fc5\u586b\u6216\u8005actions\u540d\u79f0\u91cd\u590d", e);
        }
    }

    @Override
    public WebAuthAction getAction(String name) {
        return this.actionMap.get(name);
    }

    @Override
    public final WebAuthAction matcher(HttpServletRequest request) {
        Object action = request.getAttribute("HANDLE_AUTH_ACTION");
        if (action != null) {
            return (WebAuthAction)action;
        }
        String requestURI = WebUtils.getRequestUriContext(request);
        for (WebAuthAction item : this.actions) {
            if (!item.pathMatcher(requestURI, request)) continue;
            request.setAttribute("HANDLE_AUTH_ACTION", (Object)item);
            return item;
        }
        return null;
    }

    @Override
    public List<WebAuthAction> getActions() {
        return this.actions;
    }

    public void afterPropertiesSet() throws Exception {
    }

    @Override
    public FrameworkProperties getConfig() {
        return this.config;
    }

    @Autowired
    public DefaultAuthHandler setConfig(FrameworkProperties config) {
        this.config = config;
        return this;
    }
}

