/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.lcd.gen;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.IKeyWordsHandler;
import com.baomidou.mybatisplus.generator.config.INameConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iteaj.framework.result.ListResult;
import com.iteaj.framework.spring.SpringUtils;
import com.iteaj.iboot.msn.lcd.design.LcdInjectionConfig;
import com.iteaj.iboot.msn.lcd.entity.LcdDesign;
import com.iteaj.iboot.msn.lcd.gen.DesignTableInfo;
import com.iteaj.iboot.msn.lcd.gen.FormField;
import com.iteaj.iboot.msn.lcd.gen.FormTableField;
import com.iteaj.iboot.msn.lcd.gen.JoinTable;
import com.iteaj.iboot.msn.lcd.gen.LcdField;
import com.iteaj.iboot.msn.lcd.service.ILcdDesignService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public class DesignConfigBuilder {
    private DataSourceConfig dataSourceConfig;
    private final TemplateConfig template;
    private List<TableInfo> tableInfoList;
    private Map<String, String> packageInfo;
    private Map<String, String> pathInfo;
    private StrategyConfig strategyConfig;
    private GlobalConfig globalConfig;
    private LcdInjectionConfig injectionConfig;
    private static final Pattern REGX = Pattern.compile("[~!/@#$%^&*()+\\\\\\[\\]|{};:'\",<.>?]+");

    public DesignConfigBuilder(PackageConfig packageConfig, DataSourceConfig dataSourceConfig, StrategyConfig strategyConfig, TemplateConfig template, GlobalConfig globalConfig, List<String> tableNames) {
        this.globalConfig = Optional.ofNullable(globalConfig).orElseGet(GlobalConfig::new);
        this.template = Optional.ofNullable(template).orElseGet(TemplateConfig::new);
        this.template.setXml("/templates/lcd.mapper.xml");
        this.template.setEntity("/templates/lcd.entity.java");
        this.template.setMapper("/templates/lcd.mapper.java");
        this.template.setService("/templates/lcd.service.java");
        this.template.setController("/templates/lcd.controller.java");
        this.template.setServiceImpl("/templates/lcd.serviceImpl.java");
        if (null == packageConfig) {
            this.handlerPackage(this.template, this.globalConfig.getOutputDir(), new PackageConfig());
        } else {
            this.handlerPackage(this.template, this.globalConfig.getOutputDir(), packageConfig);
        }
        this.dataSourceConfig = dataSourceConfig;
        this.strategyConfig = Optional.ofNullable(strategyConfig).orElseGet(StrategyConfig::new);
        this.tableInfoList = this.getTablesInfo(strategyConfig, tableNames);
    }

    public Map<String, String> getPackageInfo() {
        return this.packageInfo;
    }

    public Map<String, String> getPathInfo() {
        return this.pathInfo;
    }

    public List<TableInfo> getTableInfoList() {
        return this.tableInfoList;
    }

    public DesignConfigBuilder setTableInfoList(List<TableInfo> tableInfoList) {
        this.tableInfoList = tableInfoList;
        return this;
    }

    public TemplateConfig getTemplate() {
        return this.template;
    }

    protected void handlerPackage(TemplateConfig template, String outputDir, PackageConfig config) {
        this.packageInfo = CollectionUtils.newHashMapWithExpectedSize((int)7);
        this.packageInfo.put("ModuleName", config.getModuleName());
        this.packageInfo.put("Dto", this.joinPackage(config.getParent(), "dto"));
        this.packageInfo.put("Entity", this.joinPackage(config.getParent(), config.getEntity()));
        this.packageInfo.put("Mapper", this.joinPackage(config.getParent(), config.getMapper()));
        this.packageInfo.put("Xml", this.joinPackage(config.getParent(), config.getXml()));
        this.packageInfo.put("Service", this.joinPackage(config.getParent(), config.getService()));
        this.packageInfo.put("ServiceImpl", this.joinPackage(config.getParent(), config.getServiceImpl()));
        this.packageInfo.put("Controller", this.joinPackage(config.getParent(), config.getController()));
        Map configPathInfo = config.getPathInfo();
        if (null != configPathInfo) {
            this.pathInfo = configPathInfo;
        } else {
            this.pathInfo = CollectionUtils.newHashMapWithExpectedSize((int)6);
            this.setPathInfo(this.pathInfo, template.getEntity(this.getGlobalConfig().isKotlin()), outputDir, "entity_path", "Entity");
            this.setPathInfo(this.pathInfo, template.getMapper(), outputDir, "mapper_path", "Mapper");
            this.setPathInfo(this.pathInfo, template.getXml(), outputDir, "xml_path", "Xml");
            this.setPathInfo(this.pathInfo, "lcd.dto.java", outputDir, "dto_path", "Dto");
            this.setPathInfo(this.pathInfo, template.getService(), outputDir, "service_path", "Service");
            this.setPathInfo(this.pathInfo, template.getServiceImpl(), outputDir, "service_impl_path", "ServiceImpl");
            this.setPathInfo(this.pathInfo, template.getController(), outputDir, "controller_path", "Controller");
        }
    }

    protected void setPathInfo(Map<String, String> pathInfo, String template, String outputDir, String path, String module) {
        if (StringUtils.isNotBlank((CharSequence)template)) {
            pathInfo.put(path, this.joinPath(outputDir, this.packageInfo.get(module)));
        }
    }

    protected List<TableInfo> processTable(List<TableInfo> tableList, StrategyConfig config) {
        for (TableInfo tableInfo : tableList) {
            INameConvert nameConvert = this.strategyConfig.getNameConvert();
            String entityName = null != nameConvert ? nameConvert.entityNameConvert(tableInfo) : NamingStrategy.capitalFirst((String)this.processName(tableInfo.getName(), config.getNaming(), config.getTablePrefix()));
            if (StringUtils.isNotBlank((CharSequence)this.globalConfig.getEntityName())) {
                tableInfo.setConvert(true);
                tableInfo.setEntityName(String.format(this.globalConfig.getEntityName(), entityName));
            } else {
                tableInfo.setEntityName(this.strategyConfig, entityName);
            }
            if (StringUtils.isNotBlank((CharSequence)this.globalConfig.getMapperName())) {
                tableInfo.setMapperName(String.format(this.globalConfig.getMapperName(), entityName));
            } else {
                tableInfo.setMapperName(entityName + "Mapper");
            }
            if (StringUtils.isNotBlank((CharSequence)this.globalConfig.getXmlName())) {
                tableInfo.setXmlName(String.format(this.globalConfig.getXmlName(), entityName));
            } else {
                tableInfo.setXmlName(entityName + "Mapper");
            }
            if (StringUtils.isNotBlank((CharSequence)this.globalConfig.getServiceName())) {
                tableInfo.setServiceName(String.format(this.globalConfig.getServiceName(), entityName));
            } else {
                tableInfo.setServiceName("I" + entityName + "Service");
            }
            if (StringUtils.isNotBlank((CharSequence)this.globalConfig.getServiceImplName())) {
                tableInfo.setServiceImplName(String.format(this.globalConfig.getServiceImplName(), entityName));
            } else {
                tableInfo.setServiceImplName(entityName + "ServiceImpl");
            }
            if (StringUtils.isNotBlank((CharSequence)this.globalConfig.getControllerName())) {
                tableInfo.setControllerName(String.format(this.globalConfig.getControllerName(), entityName));
            } else {
                tableInfo.setControllerName(entityName + "Controller");
            }
            this.checkImportPackages(tableInfo);
        }
        return tableList;
    }

    protected void checkImportPackages(TableInfo tableInfo) {
        if (StringUtils.isNotBlank((CharSequence)this.strategyConfig.getSuperEntityClass())) {
            tableInfo.getImportPackages().add(this.strategyConfig.getSuperEntityClass());
        } else if (this.globalConfig.isActiveRecord()) {
            tableInfo.getImportPackages().add(Model.class.getCanonicalName());
        }
        if (null != this.globalConfig.getIdType() && tableInfo.isHavePrimaryKey()) {
            tableInfo.getImportPackages().add(IdType.class.getCanonicalName());
            tableInfo.getImportPackages().add(TableId.class.getCanonicalName());
        }
        if (StringUtils.isNotBlank((CharSequence)this.strategyConfig.getVersionFieldName()) && CollectionUtils.isNotEmpty((Collection)tableInfo.getFields())) {
            tableInfo.getFields().forEach(f -> {
                if (this.strategyConfig.getVersionFieldName().equals(f.getName())) {
                    tableInfo.getImportPackages().add(Version.class.getCanonicalName());
                }
            });
        }
    }

    protected List<TableInfo> getTablesInfo(StrategyConfig config, List<String> tableNames) {
        ArrayList<TableInfo> tableInfos = new ArrayList<TableInfo>();
        ILcdDesignService designService = (ILcdDesignService)SpringUtils.getBean(ILcdDesignService.class);
        ListResult listResult = designService.list((Wrapper)Wrappers.lambdaQuery().in(LcdDesign::getTableName, tableNames));
        listResult.forEach(item -> {
            DesignTableInfo tableInfo = new DesignTableInfo();
            tableInfo.setComment(item.getComment()).setConvert(true).setName(item.getTableName());
            tableInfos.add(this.convertTableFields(tableInfo, (LcdDesign)((Object)item)));
        });
        return this.processTable(tableInfos, this.strategyConfig);
    }

    protected boolean tableNameMatches(String setTableName, String dbTableName) {
        return setTableName.equalsIgnoreCase(dbTableName) || StringUtils.matches((String)setTableName, (String)dbTableName);
    }

    protected TableInfo convertTableFields(DesignTableInfo tableInfo, LcdDesign entity) {
        JsonNode table;
        JsonNode keyField;
        JsonNode tabModel;
        boolean haveId = false;
        ArrayList<LcdField> fieldList = new ArrayList<LcdField>();
        ArrayList<LcdField> dtoFields = new ArrayList<LcdField>();
        ArrayList foreign = new ArrayList();
        ArrayList<FormField> formFields = new ArrayList<FormField>();
        ArrayList<FormField> searchFields = new ArrayList<FormField>();
        ArrayList<JoinTable> joinTables = new ArrayList<JoinTable>();
        HashMap<String, Character> tableAlias = new HashMap<String, Character>();
        ArrayList<FormTableField> formTableFields = new ArrayList<FormTableField>();
        HashMap idMaps = new HashMap();
        ArrayList<LcdField> commonFieldList = new ArrayList<LcdField>();
        char startAlias = 'a';
        AtomicInteger aliasSetup = new AtomicInteger(1);
        tableAlias.put(tableInfo.getName(), Character.valueOf(startAlias));
        JsonNode container = entity.getContainer().get("meta");
        if (container != null && !container.isNull() && (tabModel = container.get("tabModel")) instanceof ObjectNode && (keyField = tabModel.get("keyField")) != null && !keyField.isNull()) {
            LcdField lcdField = new LcdField();
            String field = keyField.asText();
            lcdField.setName(field);
            lcdField.setKeyFlag(true);
            lcdField.setType(tabModel.get("keyType").asText());
            lcdField.setComment(tabModel.get("comment").asText());
            tableInfo.setKeyField(field);
            this.handleFieldConvert(lcdField);
            if (this.strategyConfig.includeSuperEntityColumns(lcdField.getName())) {
                commonFieldList.add(lcdField);
            } else {
                fieldList.add(lcdField);
            }
        }
        ArrayNode metas = (ArrayNode)entity.getEdit().withArray("metas");
        metas.forEach(item -> {
            LcdField field = new LcdField();
            ObjectNode meta = (ObjectNode)item;
            ObjectNode tabModel = (ObjectNode)meta.get("tabModel");
            idMaps.put(meta.get("id").asText(), field);
            String columnName = tabModel.get("field").asText();
            String title = tabModel.get("title").asText();
            String type = tabModel.get("type").asText();
            field.setName(columnName);
            field.setTitle(title);
            String newColumnName = columnName;
            field.setFormType(type);
            field.setTable(tableInfo.getName());
            field.setType(tabModel.get("fieldType").asText());
            IKeyWordsHandler keyWordsHandler = this.dataSourceConfig.getKeyWordsHandler();
            if (keyWordsHandler != null && keyWordsHandler.isKeyWords(columnName)) {
                System.err.printf("\u5f53\u524d\u8868[%s]\u5b58\u5728\u5b57\u6bb5[%s]\u4e3a\u6570\u636e\u5e93\u5173\u952e\u5b57\u6216\u4fdd\u7559\u5b57!%n", tableInfo.getName(), columnName);
                field.setKeyWords(true);
                newColumnName = keyWordsHandler.formatColumn(columnName);
            }
            field.setColumnName(newColumnName);
            this.handleFieldConvert(field);
            this.handleExcel(tableInfo, field, tabModel, title);
            this.handleValidate(tableInfo, field, tabModel, title, type);
            if (tabModel.get("isDb").asBoolean()) {
                fieldList.add(field);
                field.setComment(tabModel.get("comment").asText());
                if ("foreign".equals(type)) {
                    foreign.add(field);
                    String quoteTable = tabModel.get("quoteTable").asText();
                    if (!tableAlias.containsKey(quoteTable)) {
                        tableAlias.put(quoteTable, Character.valueOf((char)(startAlias + aliasSetup.getAndIncrement())));
                    }
                    joinTables.add(new JoinTable(quoteTable, ((Character)tableAlias.get(quoteTable)).toString(), tabModel.get("foreignId").asText(), tabModel.get("field").asText()));
                }
                if (this.strategyConfig.includeSuperEntityColumns(field.getName())) {
                    commonFieldList.add(field);
                    return;
                }
            } else if ("quote".equals(type)) {
                JsonNode target;
                String quoteTable = tabModel.get("quoteTable").asText();
                field.setAlias(((Character)tableAlias.get(quoteTable)).toString());
                dtoFields.add(field);
                field.setTable(tabModel.get("quoteTable").asText());
                if (field.getColumnType().getPkg() != null) {
                    tableInfo.getDtoImportPackages().add(field.getColumnType().getPkg());
                }
                if ((target = tabModel.get("target")) instanceof ObjectNode) {
                    field.setComment(target.get("comment").asText(""));
                }
                if (StringUtils.isNotBlank((CharSequence)field.getExcel())) {
                    tableInfo.getDtoImportPackages().add("cn.afterturn.easypoi.excel.annotation.*");
                }
            }
        });
        ArrayNode edit = (ArrayNode)entity.getIvzone().withArray("edit");
        if (edit != null) {
            edit.forEach(item -> {
                String id = item.get("id").asText();
                LcdField tableField = (LcdField)((Object)((Object)idMaps.get(id)));
                formFields.add(new FormField().setComponent(String.format(item.get("template").asText(), tableField.getPropertyName(), tableField.getTitle())));
            });
        }
        HashMap searchIdTitleMaps = new HashMap();
        entity.getSearch().withArray("metas").forEach(meta -> searchIdTitleMaps.put(meta.get("id").asText(), meta.get("tabModel").get("title").asText()));
        JsonNode search = entity.getIvzone().withArray("search");
        if (search != null) {
            search.forEach(item -> {
                String id = item.get("id").asText();
                LcdField tableField = (LcdField)((Object)((Object)idMaps.get(id)));
                FormField formField = new FormField().setComponent(String.format(item.get("template").asText(), tableField.getPropertyName(), searchIdTitleMaps.get(id))).setTable(tableField.getTable()).setAlias(((Character)tableAlias.get(tableField.getTable())).toString()).setColumnName(tableField.getColumnName()).setPropertyName(tableField.getPropertyName()).setType(tableField.getColumnType());
                searchFields.add(formField);
            });
        }
        if ((table = entity.getIvzone().withArray("table")) != null) {
            table.forEach(item -> {
                String id = item.get("id").asText();
                TableField tableField = (TableField)idMaps.get(id);
                FormTableField formTableField = new FormTableField();
                String template = item.get("template").asText();
                if (id.equalsIgnoreCase("action")) {
                    formTableField.setComponent(String.format(template, "action"));
                } else {
                    formTableField.setComponent(String.format(template, tableField.getPropertyName()));
                }
                formTableFields.add(formTableField);
            });
        }
        tableInfo.setFields(fieldList);
        tableInfo.setDtoFields(dtoFields);
        tableInfo.setFormFields(formFields);
        tableInfo.setJoinTables(joinTables);
        tableInfo.setSearchFields(searchFields);
        tableInfo.setCommonFields(commonFieldList);
        tableInfo.setFormTableFields(formTableFields);
        return tableInfo;
    }

    private void handleFieldConvert(LcdField field) {
        INameConvert nameConvert = this.strategyConfig.getNameConvert();
        if (null != nameConvert) {
            field.setPropertyName(nameConvert.propertyNameConvert((TableField)field));
        } else {
            field.setPropertyName(this.strategyConfig, this.processName(field.getName(), this.strategyConfig.getColumnNaming()));
        }
        field.setColumnType(this.dataSourceConfig.getTypeConvert().processTypeConvert(this.globalConfig, (TableField)field));
        List tableFillList = this.getStrategyConfig().getTableFillList();
        if (null != tableFillList) {
            tableFillList.stream().filter(tf -> tf.getFieldName().equalsIgnoreCase(field.getName())).findFirst().ifPresent(tf -> field.setFill(tf.getFieldFill().name()));
        }
    }

    private void handleExcel(DesignTableInfo tableInfo, LcdField field, ObjectNode tabModel, String title) {
        JsonNode anImport = tabModel.get("isImport");
        JsonNode anExport = tabModel.get("isExport");
        if (anImport != null && anExport != null) {
            Boolean isImport = anImport.asBoolean(false);
            Boolean isExport = anExport.asBoolean(false);
            if (isImport.booleanValue() || isExport.booleanValue()) {
                StringBuilder excel = new StringBuilder("@Excel(name=").append('\"').append(title).append('\"');
                if (isImport.booleanValue()) {
                    excel.append(", isImportField=\"true\"");
                }
                excel.append(")");
                field.setExcel(excel.toString());
                tableInfo.getImportPackages().add("cn.afterturn.easypoi.excel.annotation.*");
            }
        }
    }

    private void handleValidate(DesignTableInfo tableInfo, LcdField field, ObjectNode tabModel, String title, String type) {
        JsonNode rules = tabModel.get("rules");
        if (rules instanceof ArrayNode) {
            JsonNode jsonNode = rules.get(0);
            StringBuilder validate = new StringBuilder();
            if (jsonNode instanceof ObjectNode) {
                boolean required = jsonNode.get("required").asBoolean();
                if (required) {
                    if (type.equals("number") || type.equals("slider") || type.equals("rate")) {
                        validate.append("@NotNull(message=").append('\"').append(title).append("\u5fc5\u586b").append('\"').append(")");
                    } else {
                        validate.append("@NotBlank(message=").append('\"').append(title).append("\u5fc5\u586b").append('\"').append(")");
                    }
                }
                field.setValidate(validate.toString());
                tableInfo.getImportPackages().add("javax.validation.constraints.*");
            }
        }
    }

    protected String joinPath(String parentDir, String packageName) {
        if (StringUtils.isBlank((CharSequence)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((String)parentDir, (String)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    protected String joinPackage(String parent, String subPackage) {
        return StringUtils.isBlank((CharSequence)parent) ? subPackage : parent + "." + subPackage;
    }

    protected String processName(String name, NamingStrategy strategy) {
        return this.processName(name, strategy, this.strategyConfig.getFieldPrefix());
    }

    protected String processName(String name, NamingStrategy strategy, Set<String> prefix) {
        String propertyName = prefix.size() > 0 ? (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.removePrefixAndCamel((String)name, prefix) : NamingStrategy.removePrefix((String)name, prefix)) : (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.underlineToCamel((String)name) : name);
        return propertyName;
    }

    public StrategyConfig getStrategyConfig() {
        return this.strategyConfig;
    }

    public DesignConfigBuilder setStrategyConfig(StrategyConfig strategyConfig) {
        this.strategyConfig = strategyConfig;
        return this;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public DesignConfigBuilder setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }

    public LcdInjectionConfig getInjectionConfig() {
        return this.injectionConfig;
    }

    public DesignConfigBuilder setInjectionConfig(LcdInjectionConfig injectionConfig) {
        this.injectionConfig = injectionConfig;
        return this;
    }

    public String formatComment(String comment) {
        return StringUtils.isBlank((CharSequence)comment) ? "" : comment.replaceAll("\r\n", "\t");
    }
}

