/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.core.controller;

import com.iteaj.framework.BaseController;
import com.iteaj.framework.autoconfigure.FrameworkProperties;
import com.iteaj.framework.result.Result;
import com.iteaj.framework.security.shiro.ShiroUtil;
import com.iteaj.iboot.msn.core.entity.Admin;
import com.iteaj.util.CommonUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/common/upload"})
public class UploadController
extends BaseController
implements InitializingBean {
    private File rootDir;
    private String uploadRootUri;
    private String commonSubPath = "/common/";
    private final FrameworkProperties properties;

    public UploadController(FrameworkProperties properties) {
        this.properties = properties;
    }

    @PostMapping
    public Result<String> upload(MultipartFile file, String subPath) {
        try {
            String fileUrl = this.createFile(file, subPath);
            return this.success((Object)fileUrl, "\u4e0a\u4f20\u6210\u529f");
        }
        catch (IOException e) {
            return this.fail("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    @PostMapping(value={"/batch"})
    public Result<List<String>> batch(MultipartFile[] file, String subPath) {
        ArrayList urls = new ArrayList();
        try {
            Arrays.asList(file).forEach(item -> {
                try {
                    urls.add(this.createFile(item, subPath));
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            });
        }
        catch (Exception e) {
            return this.fail("\u4e0a\u4f20\u5931\u8d25");
        }
        return this.success(urls);
    }

    @PostMapping(value={"avatar"})
    public Result avatar(MultipartFile avatar) {
        try {
            Admin admin = (Admin)ShiroUtil.getUser();
            String fileUrl = this.createFile(avatar, "avatar_" + admin.getId(), "/avatar");
            return this.success((Object)fileUrl, "\u4e0a\u4f20\u6210\u529f");
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return this.fail("\u4e0a\u4f20\u5931\u8d25");
        }
    }

    private String createFile(MultipartFile file, String subPath) throws IOException {
        String filePath = this.genFilePath(file.getOriginalFilename(), subPath);
        InputStream inputStream = file.getInputStream();
        File outFile = new File(this.rootDir, filePath);
        if (!outFile.getParentFile().exists()) {
            outFile.mkdirs();
        }
        FileCopyUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(outFile));
        return this.uploadRootUri + filePath;
    }

    private String createFile(MultipartFile file, String fileName, String subPath) throws IOException {
        String filePath = this.genFilePath(file.getOriginalFilename(), fileName, subPath);
        InputStream inputStream = file.getInputStream();
        File outFile = new File(this.rootDir, filePath);
        if (!outFile.getParentFile().exists()) {
            outFile.mkdirs();
        }
        if (!outFile.exists()) {
            outFile.createNewFile();
        }
        FileCopyUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(outFile));
        return this.uploadRootUri + filePath;
    }

    private String genFilePath(String originalFilename, String subPath) {
        return this.genFilePath(originalFilename, null, subPath);
    }

    private String genFilePath(String originalFilename, String fileName, String subPath) {
        String fileType = this.getFileType(originalFilename);
        String string = fileName = CommonUtils.isNotBlank((String)fileName) ? fileName + fileType : UUID.randomUUID() + fileType;
        if (CommonUtils.isBlank((String)subPath)) {
            subPath = this.commonSubPath;
        } else if (!subPath.endsWith("/")) {
            subPath = subPath + "/";
        }
        return subPath + fileName;
    }

    public void afterPropertiesSet() throws Exception {
        String uploadRootUri;
        String uploadRootDir = this.properties.getUploadLocation();
        if (!CommonUtils.isBlank((String)uploadRootDir)) {
            if (uploadRootDir.endsWith("/")) {
                uploadRootDir = uploadRootDir.substring(0, uploadRootDir.length() - 1);
            }
            this.rootDir = new File(uploadRootDir);
            if (!this.rootDir.exists()) {
                this.rootDir.mkdirs();
            }
            if (!this.rootDir.isDirectory()) {
                this.logger.warn("\u6587\u4ef6\u7684\u4e0a\u4f20\u6839\u8def\u5f84\u5fc5\u987b\u662f\u76ee\u5f55\uff1a" + uploadRootDir);
                return;
            }
        }
        if (!CommonUtils.isBlank((String)(uploadRootUri = this.properties.getUploadPattern()))) {
            if (uploadRootUri.contains("*")) {
                uploadRootUri = uploadRootUri.replaceAll("\\*", "");
            }
            if (uploadRootUri.endsWith("/")) {
                this.uploadRootUri = uploadRootUri.substring(0, uploadRootUri.length() - 1);
            }
            this.uploadRootUri = uploadRootUri;
        } else {
            this.logger.error("\u672a\u914d\u7f6e\u4e0a\u4f20\u6587\u4ef6\u7684\u8bbf\u95eepattern[framework.upload-pattern]");
        }
    }

    public String getFileType(String fileName) {
        return fileName.replaceFirst(".*\\.", ".");
    }
}

