/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.iteaj.framework.BaseController;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.Result;
import com.iteaj.iboot.msn.iot.collect.CollectException;
import com.iteaj.iboot.msn.iot.collect.store.StoreAction;
import com.iteaj.iboot.msn.iot.collect.store.StoreActionFactory;
import com.iteaj.iboot.msn.iot.entity.CollectDetail;
import com.iteaj.iboot.msn.iot.service.ICollectDetailService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iot/collectDetail"})
public class CollectDetailController
extends BaseController {
    @Autowired
    private ICollectDetailService collectDetailService;

    @GetMapping(value={"/details"})
    public Result<Page<CollectDetail>> details(Page page, CollectDetail entity) {
        return this.collectDetailService.detailPage(page, entity);
    }

    @GetMapping(value={"/edit"})
    public Result<CollectDetail> edit(Long id) {
        return this.collectDetailService.detailById(id);
    }

    @PostMapping(value={"/saveOrUpdate"})
    public Result<Boolean> save(@RequestBody CollectDetail entity) {
        StoreAction storeAction = StoreActionFactory.getInstance().get(entity.getStoreAction());
        if (storeAction != null) {
            try {
                storeAction.configValidate(entity.resolveConfig());
            }
            catch (CollectException e) {
                return this.fail(e.getMessage());
            }
        }
        return this.collectDetailService.saveOrUpdate((Entity)entity);
    }

    @PostMapping(value={"/del"})
    public Result<Boolean> remove(@RequestBody List<Long> idList) {
        return this.collectDetailService.removeByIds(idList);
    }
}

