/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.autoconfigure;

import com.iteaj.framework.cache.CacheEntry;
import com.iteaj.framework.cache.SerializerType;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.HashMap;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.jsr107.Eh107Configuration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.cache.jcache.JCacheCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;

@EnableCaching
public class CacheManagerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={org.springframework.cache.CacheManager.class})
    public org.springframework.cache.CacheManager defaultCacheManager() {
        return new ConcurrentMapCacheManager();
    }

    @ConditionalOnClass(name={"org.ehcache.core.EhcacheManager"})
    public static class Ehcache3Configuration {
        @Bean(value={"cacheManager", "ehcache3CacheManager"})
        @ConditionalOnMissingBean(name={"cacheManager"})
        public org.springframework.cache.CacheManager ehcache3CacheManager(ObjectProvider<CacheEntry> caches) throws URISyntaxException {
            ClassLoader classLoader = this.getClass().getClassLoader();
            CachingProvider cachingProvider = Caching.getCachingProvider((String)"org.ehcache.jsr107.EhcacheCachingProvider", (ClassLoader)classLoader);
            URL resource = classLoader.getResource("ehcache.xml");
            CacheManager cacheManager = null != resource ? cachingProvider.getCacheManager(resource.toURI(), classLoader) : cachingProvider.getCacheManager();
            caches.forEach(item -> cacheManager.createCache(item.getName(), this.doCreateCache((CacheEntry)item)));
            return new JCacheCacheManager(cacheManager);
        }

        private Configuration doCreateCache(CacheEntry item) {
            CacheConfiguration configuration = this.authCacheConfiguration(item);
            return Eh107Configuration.fromEhcacheCacheConfiguration((CacheConfiguration)configuration);
        }

        public CacheConfiguration authCacheConfiguration(CacheEntry item) {
            ResourcePoolsBuilder resourcePoolsBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder();
            ResourcePools resourcePools = resourcePoolsBuilder.heap(500L, (ResourceUnit)MemoryUnit.MB).build();
            Duration timeToLiveSeconds = Duration.ofSeconds(item.getExpire());
            return CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, item.getClazz(), (ResourcePools)resourcePools).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)timeToLiveSeconds)).withExpiry(ExpiryPolicyBuilder.timeToIdleExpiration((Duration)timeToLiveSeconds)).build();
        }
    }

    @ConditionalOnClass(name={"org.springframework.data.redis.cache.RedisCacheManager", "org.springframework.data.redis.core.RedisTemplate"})
    public static class RedisConfiguration {
        @Primary
        @Bean(value={"cacheManager", "redisCacheManager"})
        public org.springframework.cache.CacheManager redisCacheManager(RedisConnectionFactory redisConnectionFactory, ObjectProvider<CacheEntry> caches) {
            RedisCacheWriter redisCacheWriter = RedisCacheWriter.lockingRedisCacheWriter((RedisConnectionFactory)redisConnectionFactory);
            ClassLoader classLoader = this.getClass().getClassLoader();
            RedisCacheConfiguration defaultCacheConfiguration = this.defaultCacheConfiguration(classLoader);
            HashMap initCaches = new HashMap();
            caches.forEach(item -> initCaches.put(item.getName(), this.doCreateCache((CacheEntry)item, classLoader)));
            return new RedisCacheManager(redisCacheWriter, defaultCacheConfiguration, initCaches);
        }

        private RedisCacheConfiguration doCreateCache(CacheEntry item, ClassLoader classLoader) {
            RedisSerializationContext.SerializationPair serializer = item.getType() == SerializerType.Jdk ? RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new JdkSerializationRedisSerializer(classLoader)) : RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(item.getClazz()));
            RedisCacheConfiguration sessionCache = RedisCacheConfiguration.defaultCacheConfig().serializeValuesWith(serializer);
            Duration timeToLiveSeconds = Duration.ofSeconds(item.getExpire());
            sessionCache.entryTtl(timeToLiveSeconds);
            return sessionCache;
        }

        public RedisCacheConfiguration defaultCacheConfiguration(ClassLoader classLoader) {
            return RedisCacheConfiguration.defaultCacheConfig().serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new JdkSerializationRedisSerializer(classLoader)));
        }
    }
}

