/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.autoconfigure;

import com.google.code.kaptcha.Producer;
import com.iteaj.framework.captcha.KaptchaCreator;
import com.iteaj.framework.security.OrderFilterChainDefinition;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(value={"/valid"})
@Controller(value="CaptchaController")
public class CaptchaAutoConfiguration {
    @Autowired
    private Producer producer;

    @GetMapping(value={"/captcha"})
    public void captcha(HttpSession session, HttpServletResponse response) throws IOException {
        try (ServletOutputStream out = response.getOutputStream();){
            this.handleResponseHeader(response);
            String[] split = this.producer.createText().split("@");
            BufferedImage image = this.producer.createImage(split[0]);
            session.setAttribute("KAPTCHA_SESSION_KEY", (Object)(split.length == 2 ? split[1] : split[0]));
            session.setAttribute("KAPTCHA_SESSION_DATE", (Object)System.currentTimeMillis());
            ImageIO.write((RenderedImage)image, "jpg", (OutputStream)out);
            out.flush();
        }
    }

    private void handleResponseHeader(HttpServletResponse response) {
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setContentType("image/jpeg");
    }

    @Bean
    @Order(value=20)
    public OrderFilterChainDefinition captchaFilterChainDefinition() {
        OrderFilterChainDefinition chain = new OrderFilterChainDefinition();
        chain.addPathDefinition("/valid/captcha", "anon");
        return chain;
    }

    @Bean(name={"charCaptcha"})
    @ConditionalOnProperty(value={"msn.core.captcha-type"}, havingValue="char")
    public Producer charCaptcha() {
        return KaptchaCreator.charInstance();
    }

    @Primary
    @Bean(name={"mathCaptcha"})
    @ConditionalOnProperty(value={"msn.core.captcha-type"}, havingValue="math")
    public Producer mathCaptcha() {
        return KaptchaCreator.mathInstance();
    }
}

