/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.result;

import com.iteaj.framework.result.AbstractResult;
import com.iteaj.framework.result.HttpResult;
import java.util.Optional;
import java.util.function.BiConsumer;

public abstract class OptionalResult<E, _this extends AbstractResult<E>>
extends AbstractResult<E> {
    public static long DCODE = HttpResult.DEFAULT_SUCCESS_CODE;
    public static String DMSG = HttpResult.DEFAULT_SUCCESS_MSG;

    protected OptionalResult(E value) {
        this(value, DMSG, DCODE);
    }

    public OptionalResult(E data, String message, long code) {
        super(data, message, code);
    }

    public Optional<E> of() {
        return Optional.of(this.getData());
    }

    public _this ifPresent(BiConsumer<E, _this> consumer) {
        if (this.getData() != null) {
            consumer.accept(this.getData(), this);
        }
        return (_this)this;
    }

    public Optional<E> ofNullable() {
        return Optional.ofNullable(this.getData());
    }

    public _this ok() {
        return this.ok(DMSG);
    }

    public _this ok(String msg) {
        this.setCode(DCODE);
        this.setMessage(msg);
        return (_this)this;
    }

    public _this fail() {
        return this.fail(HttpResult.DEFAULT_ERROR_CODE, HttpResult.DEFAULT_ERROR_MSG);
    }

    public _this fail(String msg) {
        return this.fail(HttpResult.DEFAULT_ERROR_CODE, msg);
    }

    public _this fail(long code, String msg) {
        this.setCode(code);
        this.setMessage(msg);
        return (_this)this;
    }

    @Override
    public _this setCode(long code) {
        return (_this)super.setCode(code);
    }

    @Override
    public _this setMessage(String message) {
        return (_this)super.setMessage(message);
    }

    public _this setData(E data) {
        return (_this)super.setData(data);
    }
}

