/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.security.shiro;

import com.iteaj.framework.exception.ServiceException;
import com.iteaj.framework.logger.AccessLogger;
import com.iteaj.framework.logger.LoggerMenu;
import com.iteaj.framework.logger.LoggerService;
import com.iteaj.framework.web.WebUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.util.ThreadContext;
import org.apache.shiro.web.filter.InvalidRequestFilter;
import org.apache.shiro.web.filter.mgt.DefaultFilter;
import org.apache.shiro.web.filter.mgt.FilterChainManager;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.filter.mgt.PathMatchingFilterChainResolver;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.AbstractShiroFilter;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Autowired;

public class ShiroFilterLogFactoryBean
extends ShiroFilterFactoryBean {
    @Autowired(required=false)
    private LoggerService loggerService;

    protected AbstractShiroFilter createInstance() throws Exception {
        SecurityManager securityManager = this.getSecurityManager();
        if (securityManager == null) {
            String msg = "SecurityManager property must be set.";
            throw new BeanInitializationException(msg);
        }
        if (!(securityManager instanceof WebSecurityManager)) {
            String msg = "The security manager does not implement the WebSecurityManager interface.";
            throw new BeanInitializationException(msg);
        }
        FilterChainManager manager = this.createFilterChainManager();
        InvalidRequestFilter chain = (InvalidRequestFilter)manager.getFilters().get(DefaultFilter.invalidRequest.name());
        if (chain != null) {
            chain.setBlockNonAscii(false);
        }
        PathMatchingFilterChainResolver chainResolver = new PathMatchingFilterChainResolver();
        chainResolver.setFilterChainManager(manager);
        return new SpringShiroFilter((WebSecurityManager)securityManager, (FilterChainResolver)chainResolver);
    }

    private final class SpringShiroFilter
    extends AbstractShiroFilter {
        protected SpringShiroFilter(WebSecurityManager webSecurityManager, FilterChainResolver resolver) {
            if (webSecurityManager == null) {
                throw new IllegalArgumentException("WebSecurityManager property cannot be null.");
            }
            this.setSecurityManager(webSecurityManager);
            if (resolver != null) {
                this.setFilterChainResolver(resolver);
            }
        }

        protected void executeChain(ServletRequest request, ServletResponse response, FilterChain origChain) throws IOException, ServletException {
            ThreadContext.put((Object)"HTTP_SERVLET_REQUEST", (Object)request);
            if (ShiroFilterLogFactoryBean.this.loggerService != null) {
                HttpServletRequest servletRequest = (HttpServletRequest)request;
                String requestURI = servletRequest.getRequestURI();
                LoggerMenu loggerMenu = ShiroFilterLogFactoryBean.this.loggerService.getLoggerMenu(requestURI);
                if (loggerMenu != null && loggerMenu.isCollect()) {
                    long startMills = System.currentTimeMillis();
                    AccessLogger logger = new AccessLogger(requestURI, "\u6267\u884c\u6210\u529f");
                    try {
                        logger.setStatus(true).setIp(WebUtils.getIpAddress(servletRequest));
                        super.executeChain(request, response, origChain);
                    }
                    catch (Throwable e) {
                        if (e.getCause() instanceof ServiceException) {
                            logger.setStatus(false);
                            logger.setRemark(e.getCause().getMessage());
                        } else {
                            logger.setStatus(false);
                            logger.setRemark("\u672a\u77e5\u9519\u8bef");
                        }
                        throw e;
                    }
                    finally {
                        long endMills = System.currentTimeMillis();
                        logger.setExecTime(endMills - startMills);
                        ShiroFilterLogFactoryBean.this.loggerService.record(logger);
                    }
                } else {
                    super.executeChain(request, response, origChain);
                }
            } else {
                super.executeChain(request, response, origChain);
            }
        }
    }
}

