/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.framework.utils;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import com.iteaj.framework.exception.ServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.web.multipart.MultipartFile;

public final class ExcelUtils {
    public static void exportForXSSF(Collection<?> records, Class<?> entityClass, OutputStream outputStream) throws IOException {
        ExportParams exportParams = new ExportParams();
        Workbook sheets = ExcelExportUtil.exportExcel((ExportParams)exportParams, entityClass, records);
        sheets.write(outputStream);
        outputStream.flush();
        outputStream.flush();
    }

    public static void exportForHSSF(Collection<?> records, Class<?> entityClass, OutputStream outputStream) throws IOException {
        ExportParams exportParams = new ExportParams();
        Workbook sheets = ExcelExportUtil.exportExcel((ExportParams)exportParams, entityClass, records);
        sheets.write(outputStream);
        outputStream.flush();
        outputStream.flush();
    }

    public static void exportExcel(Collection<?> records, Class<?> entityClass, ExportParams params, OutputStream outputStream) throws IOException {
        Workbook sheets = ExcelExportUtil.exportExcel((ExportParams)params, entityClass, records);
        sheets.write(outputStream);
        outputStream.flush();
        outputStream.close();
    }

    public static <T> List<T> importExcel(MultipartFile file, Class<T> clazz, ImportParams importParams) throws ServiceException {
        try {
            return ExcelImportUtil.importExcel((InputStream)file.getInputStream(), clazz, (ImportParams)importParams);
        }
        catch (Exception e) {
            throw new ServiceException("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25");
        }
    }
}

