/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.lcd.vue;

import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.builder.ConfigBuilder;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.baomidou.mybatisplus.generator.engine.VelocityTemplateEngine;
import com.iteaj.iboot.msn.lcd.LowCodeProperties;
import com.iteaj.iboot.msn.lcd.vue.VueInjectionConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityVueTemplateZipEngine
extends VelocityTemplateEngine {
    private ZipOutputStream zip;
    private VelocityEngine velocityEngine;
    private LowCodeProperties properties;

    public VelocityVueTemplateZipEngine(OutputStream outputStream, LowCodeProperties properties) {
        this.properties = properties;
        this.zip = new ZipOutputStream(outputStream);
    }

    public VelocityTemplateEngine init(ConfigBuilder configBuilder) {
        if (null == this.velocityEngine) {
            Properties p = new Properties();
            p.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            p.setProperty("resource.loader.file.path", "");
            p.setProperty("UTF-8", ConstVal.UTF8);
            p.setProperty("resource.default_encoding", ConstVal.UTF8);
            p.setProperty("file.resource.loader.unicode", "true");
            this.velocityEngine = new VelocityEngine(p);
        }
        this.setConfigBuilder(configBuilder);
        configBuilder.setInjectionConfig((InjectionConfig)new VueInjectionConfig(configBuilder, this.properties));
        return this;
    }

    public AbstractTemplateEngine batchOutput() {
        super.batchOutput();
        try {
            this.zip.finish();
            this.zip.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public void writer(Map<String, Object> objectMap, String templatePath, String outputFile) throws Exception {
        Template template = this.velocityEngine.getTemplate(templatePath, ConstVal.UTF8);
        try (StringWriter sw = new StringWriter();){
            template.merge((Context)new VelocityContext(objectMap), (Writer)sw);
            this.zip.putNextEntry(new ZipEntry(outputFile));
            this.zip.write(sw.toString().getBytes(StandardCharsets.UTF_8));
            this.zip.closeEntry();
        }
        logger.debug("\u6a21\u677f:" + templatePath + ";  \u6587\u4ef6:" + outputFile);
    }

    protected VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }
}

