/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.core.config.shiro;

import com.iteaj.framework.security.shiro.ShiroUtil;
import com.iteaj.iboot.msn.core.config.shiro.ShiroAdminToken;
import com.iteaj.iboot.msn.core.entity.Admin;
import com.iteaj.iboot.msn.core.service.IAdminService;
import com.iteaj.iboot.msn.core.service.IMenuService;
import com.iteaj.util.DigestUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.CredentialsException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;

public class ShiroAdminAuthRealm
extends AuthorizingRealm {
    @Autowired
    private IAdminService adminService;
    @Autowired
    private IMenuService menuService;

    public boolean supports(AuthenticationToken token) {
        return token != null && ShiroAdminToken.class.isAssignableFrom(token.getClass());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        Admin admin = (Admin)principals.getPrimaryPrincipal();
        SimpleAuthorizationInfo authorizationInfo = new SimpleAuthorizationInfo();
        List permissions = this.menuService.selectPermissions(admin.getId());
        authorizationInfo.addStringPermissions((Collection)permissions);
        return authorizationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        ShiroAdminToken shiroAdminToken = (ShiroAdminToken)token;
        String userName = shiroAdminToken.getUsername();
        String password = new String(shiroAdminToken.getPassword());
        HttpServletRequest request = ShiroUtil.getRequest();
        HttpSession session = request.getSession();
        try {
            String md5Hex;
            String captcha = shiroAdminToken.getCaptcha();
            Object attribute = session.getAttribute("KAPTCHA_SESSION_KEY");
            Long createTime = (Long)session.getAttribute("KAPTCHA_SESSION_DATE");
            if (!Objects.equals(attribute, captcha) || createTime == null) {
                throw new AuthenticationException("\u9a8c\u8bc1\u7801\u9519\u8bef");
            }
            Admin admin = this.adminService.getByAccount(userName);
            if (admin == null) {
                throw new AccountException("\u8d26\u6237\u4e0d\u5b58\u5728");
            }
            String passwordDigest = admin.getPassword().toUpperCase();
            if (!Objects.equals(passwordDigest, md5Hex = DigestUtils.md5Hex((byte[])password.getBytes()).toUpperCase())) {
                throw new CredentialsException("\u5bc6\u7801\u6821\u9a8c\u5931\u8d25");
            }
            SimpleAuthenticationInfo simpleAuthenticationInfo = new SimpleAuthenticationInfo((Object)admin, token.getCredentials(), this.getName());
            return simpleAuthenticationInfo;
        }
        finally {
            session.removeAttribute("KAPTCHA_SESSION_KEY");
            session.removeAttribute("KAPTCHA_SESSION_DATE");
        }
    }

    public boolean isPermitted(PrincipalCollection principals, String permission) {
        return ShiroUtil.isSuper() || super.isPermitted(principals, permission);
    }

    public boolean hasRole(PrincipalCollection principal, String roleIdentifier) {
        return ShiroUtil.isSuper() || super.hasRole(principal, roleIdentifier);
    }
}

