/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.core.config.shiro;

import com.iteaj.framework.Entity;
import com.iteaj.framework.security.shiro.ShiroUtil;
import com.iteaj.framework.spi.admin.event.OnlinePayload;
import com.iteaj.framework.spi.admin.event.OnlineStatus;
import com.iteaj.framework.spi.event.EventUtils;
import com.iteaj.framework.spi.event.PayloadEvent;
import com.iteaj.framework.web.WebUtils;
import eu.bitwalker.useragentutils.UserAgent;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationListener;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionListener;
import org.apache.shiro.subject.PrincipalCollection;

public class ShiroOnlineListener
implements SessionListener,
AuthenticationListener {
    public void onStart(Session session) {
    }

    public void onStop(Session session) {
        EventUtils.publish((PayloadEvent)new PayloadEvent((Object)session.getId(), (Object)new OnlinePayload(OnlineStatus.Offline, (String)((Object)session.getId())).setAccessTime(session.getLastAccessTime())));
    }

    public void onExpiration(Session session) {
        EventUtils.publish((PayloadEvent)new PayloadEvent((Object)session, (Object)new OnlinePayload(OnlineStatus.Offline, (String)((Object)session.getId())).setAccessTime(session.getLastAccessTime())));
    }

    public void onSuccess(AuthenticationToken authenticationToken, AuthenticationInfo authenticationInfo) {
        try {
            UserAgent agent = ShiroUtil.getAgent();
            String ipAddress = WebUtils.getIpAddress((HttpServletRequest)ShiroUtil.getRequest());
            HttpSession session = ShiroUtil.getRequest().getSession();
            OnlinePayload onlinePayload = new OnlinePayload(OnlineStatus.Online, session.getId()).setUserAgent(agent).setAccessIp(ipAddress).setAccessTime(new Date(session.getLastAccessedTime())).setExpireTime((long)session.getMaxInactiveInterval());
            onlinePayload.setUser((Entity)authenticationInfo.getPrincipals().getPrimaryPrincipal());
            EventUtils.publish((PayloadEvent)new PayloadEvent((Object)session.getId(), (Object)onlinePayload));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onFailure(AuthenticationToken authenticationToken, AuthenticationException e) {
    }

    public void onLogout(PrincipalCollection principalCollection) {
    }
}

