/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.core.controller;

import com.iteaj.framework.BaseController;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.Result;
import com.iteaj.framework.security.shiro.ShiroUtil;
import com.iteaj.iboot.msn.core.entity.Menu;
import com.iteaj.iboot.msn.core.service.IMenuService;
import java.io.Serializable;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/core/menu"})
public class MenuController
extends BaseController {
    private final IMenuService menuService;

    public MenuController(IMenuService menuService) {
        this.menuService = menuService;
    }

    @GetMapping(value={"/view"})
    @RequiresPermissions(value={"core:menu:view"})
    public Result<List<Menu>> list(Menu menu) {
        return this.menuService.selectMenuTrees(menu);
    }

    @GetMapping(value={"/bars"})
    public Result<List<Menu>> bars() {
        return this.menuService.selectMenuBarTrees((Long)ShiroUtil.getId(), ShiroUtil.isSuper());
    }

    @GetMapping(value={"/parent"})
    public Result<List<Menu>> parentList() {
        return this.menuService.selectParentTrees();
    }

    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"core:menu:add"})
    public Result<Boolean> add(@RequestBody Menu menu) {
        return this.menuService.save((Entity)menu);
    }

    @PostMapping(value={"/del"})
    @RequiresPermissions(value={"core:menu:del"})
    public Result<Boolean> del(@RequestBody List<Long> idList) {
        return this.menuService.removeByIds(idList);
    }

    @GetMapping(value={"/edit"})
    @RequiresPermissions(value={"core:menu:edit"})
    public Result<Menu> edit(Long id) {
        return this.menuService.getById((Serializable)id);
    }

    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"core:menu:edit"})
    public Result<Boolean> edit(@RequestBody Menu menu) {
        return this.menuService.updateById((Entity)menu);
    }
}

