/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.collect.action;

import com.iteaj.iboot.msn.iot.collect.CollectException;
import com.iteaj.iboot.msn.iot.collect.action.CollectAction;
import com.iteaj.iboot.msn.iot.dto.CollectTaskDto;
import com.iteaj.iboot.msn.iot.dto.DeviceDto;
import com.iteaj.iboot.msn.iot.entity.CollectDetail;
import com.iteaj.iboot.msn.iot.entity.Signal;
import com.iteaj.iot.consts.ExecStatus;
import com.iteaj.iot.server.dtu.impl.CommonDtuProtocol;
import com.iteaj.iot.utils.ByteUtil;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.springframework.util.StringUtils;

public class CommonDtuCollectAction
extends CollectAction {
    public String getName() {
        return "COMMON:DTU";
    }

    public String getDesc() {
        return "\u901a\u7528DTU\u91c7\u96c6\u5668";
    }

    public void validate(Signal signal) {
        if (!StringUtils.hasText((String)signal.getMessage())) {
            throw new CollectException("\u672a\u6307\u5b9a\u62a5\u6587");
        }
        if (!StringUtils.hasText((String)signal.getEncode())) {
            throw new CollectException("\u672a\u6307\u5b9a\u62a5\u6587\u7f16\u7801");
        }
    }

    public void validate(CollectDetail deviceDto) {
        super.validate(deviceDto);
    }

    protected void doExec(CollectTaskDto taskDto, CollectDetail detail, Signal signal, Consumer<String> call) {
        byte[] message = signal.getEncode().equals("HEX") ? ByteUtil.hexToByte((String)signal.getMessage()) : (signal.getEncode().equals("ASCII") ? signal.getMessage().getBytes(StandardCharsets.US_ASCII) : signal.getMessage().getBytes(StandardCharsets.UTF_8));
        DeviceDto device = detail.getDevice();
        CommonDtuProtocol protocol = new CommonDtuProtocol(device.getDeviceSn());
        byte[] read = protocol.read(message);
        if (protocol.getExecStatus() != ExecStatus.success) {
            throw new CollectException(protocol.getExecStatus().desc);
        }
        call.accept(ByteUtil.bytesToHex((byte[])read));
    }
}

