/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.iteaj.framework.BaseController;
import com.iteaj.framework.BaseEntity;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.DetailResult;
import com.iteaj.framework.result.Result;
import com.iteaj.iboot.msn.iot.consts.DeviceStatus;
import com.iteaj.iboot.msn.iot.consts.DeviceTypeAlias;
import com.iteaj.iboot.msn.iot.consts.SerialStatus;
import com.iteaj.iboot.msn.iot.dto.DeviceDto;
import com.iteaj.iboot.msn.iot.entity.Device;
import com.iteaj.iboot.msn.iot.entity.Serial;
import com.iteaj.iboot.msn.iot.service.IDeviceModelService;
import com.iteaj.iboot.msn.iot.service.IDeviceService;
import com.iteaj.iboot.msn.iot.service.ISerialService;
import com.iteaj.iot.client.ClientConnectProperties;
import com.iteaj.iot.client.IotClient;
import com.iteaj.iot.client.SocketClient;
import com.iteaj.iot.modbus.client.tcp.ModbusTcpClientComponent;
import com.iteaj.iot.serial.SerialClient;
import com.iteaj.iot.serial.SerialComponent;
import com.iteaj.iot.serial.SerialConnectProperties;
import java.io.Serializable;
import java.util.List;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iot/modbus"})
public class DeviceModbusController
extends BaseController {
    private final ISerialService serialService;
    private final IDeviceService deviceService;
    private final IDeviceModelService deviceModelService;
    private final ModbusTcpClientComponent tcpClientComponent;
    private final SerialComponent serialComponent;

    public DeviceModbusController(ISerialService serialService, IDeviceService deviceService, IDeviceModelService deviceModelService, @Autowired(required=false) ModbusTcpClientComponent tcpClientComponent, @Autowired(required=false) SerialComponent serialComponent) {
        this.serialService = serialService;
        this.deviceService = deviceService;
        this.serialComponent = serialComponent;
        this.deviceModelService = deviceModelService;
        this.tcpClientComponent = tcpClientComponent;
    }

    @GetMapping(value={"/view"})
    @RequiresPermissions(value={"iot:modbus:view"})
    public Result<IPage<DeviceDto>> list(Page<Device> page, DeviceDto entity) {
        entity.setAlias(DeviceTypeAlias.MODBUS);
        return this.deviceService.pageOfDetail(page, entity);
    }

    @GetMapping(value={"/edit"})
    @RequiresPermissions(value={"iot:modbus:edit"})
    public Result<Device> detail(Long id) {
        return this.deviceService.getById((Serializable)id);
    }

    @PostMapping(value={"/saveOrUpdate"})
    @RequiresPermissions(value={"iot:modbus:edit", "iot:modbus:add"}, logical=Logical.OR)
    public Result<Boolean> save(@RequestBody Device entity) {
        DetailResult one = entity.getId() == null ? this.deviceService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Device::getIp, (Object)entity.getIp())).eq(Device::getPort, (Object)entity.getPort())) : this.deviceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Device::getIp, (Object)entity.getIp())).ne(BaseEntity::getId, (Object)entity.getId())).eq(Device::getPort, (Object)entity.getPort()));
        if (one.ofNullable().isPresent()) {
            return this.fail("\u5df2\u7ecf\u5305\u542b\u6709\u8bbe\u5907[" + entity.getIp() + ":" + entity.getPort() + "]");
        }
        return this.deviceService.saveOrUpdate((Entity)entity);
    }

    @PostMapping(value={"/del"})
    @RequiresPermissions(value={"iot:modbus:del"})
    public Result<Boolean> remove(@RequestBody List<Long> idList) {
        return this.deviceService.removeByIds(idList);
    }

    @PostMapping(value={"connect/{status}"})
    @RequiresPermissions(value={"iot:modbus:connect"})
    public Result connect(@RequestBody Device device, @PathVariable DeviceStatus status) {
        if (status == null) {
            return this.fail("\u672a\u6307\u5b9a\u8fde\u63a5\u72b6\u6001");
        }
        DeviceDto entity = (DeviceDto)this.deviceService.detailById(device.getId()).getData();
        if (entity == null) {
            return this.fail("\u8bbe\u5907\u4e0d\u5b58\u5728[" + device.getDeviceSn() + "]");
        }
        try {
            String modelName = entity.getModelName();
            if (modelName.toLowerCase().contains("rtu")) {
                Serial serial = (Serial)this.serialService.getByCom(entity.getDeviceSn()).getData();
                if (serial == null) {
                    return this.fail("\u4e32\u53e3\u4e0d\u5b58\u5728[" + entity.getDeviceSn() + "]");
                }
                SerialClient client = this.serialComponent.getClient((Object)entity.getDeviceSn());
                if (status == DeviceStatus.online) {
                    if (client == null) {
                        SerialConnectProperties config = new SerialConnectProperties(serial.getCom(), serial.getBaudRate().intValue()).config(serial.getDataBits().intValue(), serial.getStopBits().intValue(), serial.getParity().intValue());
                        client = this.serialComponent.createNewClient((ClientConnectProperties)config);
                        client.init(null);
                    }
                    if (!client.isOpen()) {
                        if (!client.open()) {
                            return this.fail("\u8fde\u63a5\u5931\u8d25");
                        }
                        this.serialComponent.addClient((Object)client.getConnectProperties(), (IotClient)client);
                    }
                    this.serialService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(Serial::getStatus, (Object)SerialStatus.open)).eq(BaseEntity::getId, (Object)serial.getId()));
                    this.deviceService.update(device.getDeviceSn(), status);
                    return this.success("\u8fde\u63a5\u6210\u529f");
                }
                if (client != null) {
                    if (client.disconnect(false).booleanValue()) {
                        this.serialService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(Serial::getStatus, (Object)SerialStatus.close)).eq(BaseEntity::getId, (Object)serial.getId()));
                        this.deviceService.update(device.getDeviceSn(), status);
                        return this.success("\u65ad\u5f00\u6210\u529f");
                    }
                    return this.success("\u65ad\u5f00\u5931\u8d25");
                }
                return this.fail("\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728");
            }
            ClientConnectProperties properties = new ClientConnectProperties(entity.getIp(), entity.getPort(), entity.getDeviceSn());
            SocketClient client = this.tcpClientComponent.getClient((Object)properties);
            if (status == DeviceStatus.online) {
                if (client == null) {
                    this.tcpClientComponent.createNewClientAndConnect(properties);
                } else {
                    client.reconnection();
                }
            } else {
                client.disconnect(false);
            }
            return this.success(status == DeviceStatus.online ? "\u8fde\u63a5\u6210\u529f" : "\u65ad\u5f00\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.fail(e.getMessage());
        }
    }
}

