/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.iteaj.framework.BaseController;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.Result;
import com.iteaj.iboot.msn.iot.entity.DeviceModel;
import com.iteaj.iboot.msn.iot.service.IDeviceModelService;
import java.io.Serializable;
import java.util.List;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iot/deviceModel"})
public class DeviceModelController
extends BaseController {
    private final IDeviceModelService deviceModelService;

    public DeviceModelController(IDeviceModelService deviceModelService) {
        this.deviceModelService = deviceModelService;
    }

    @GetMapping(value={"/view"})
    @RequiresPermissions(value={"iot:deviceModel:view"})
    public Result<IPage<DeviceModel>> list(Page<DeviceModel> page, DeviceModel entity) {
        return this.deviceModelService.detailOfPage(page, entity);
    }

    @GetMapping(value={"/listByType"})
    public Result<List<DeviceModel>> listByType(Integer typeId) {
        return this.deviceModelService.list((Wrapper)Wrappers.lambdaQuery().eq(typeId != -1, DeviceModel::getTypeId, (Object)typeId));
    }

    @GetMapping(value={"/edit"})
    @RequiresPermissions(value={"iot:deviceModel:edit"})
    public Result<DeviceModel> getById(Long id) {
        return this.deviceModelService.getById((Serializable)id);
    }

    @PostMapping(value={"/saveOrUpdate"})
    @RequiresPermissions(value={"iot:deviceModel:edit", "iot:deviceModel:add"}, logical=Logical.OR)
    public Result<Boolean> save(@RequestBody DeviceModel entity) {
        return this.deviceModelService.saveOrUpdate((Entity)entity);
    }

    @PostMapping(value={"/del"})
    @RequiresPermissions(value={"iot:deviceModel:del"})
    public Result<Boolean> remove(@RequestBody List<Long> idList) {
        return this.deviceModelService.removeByIds(idList);
    }
}

