/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.debug.websocket;

import com.alibaba.fastjson.JSON;
import com.iteaj.framework.result.HttpResult;
import com.iteaj.iboot.msn.iot.debug.DebugHandle;
import com.iteaj.iboot.msn.iot.debug.DebugHandleFactory;
import com.iteaj.iboot.msn.iot.debug.DebugRequestModel;
import com.iteaj.iboot.msn.iot.debug.DebugWebsocketWrite;
import com.iteaj.iot.CoreConst;
import com.iteaj.iot.Message;
import com.iteaj.iot.codec.filter.RegisterParams;
import com.iteaj.iot.server.websocket.WebSocketServerListener;
import com.iteaj.iot.server.websocket.impl.DefaultWebSocketServerComponent;
import com.iteaj.iot.server.websocket.impl.DefaultWebSocketServerMessage;
import com.iteaj.iot.server.websocket.impl.DefaultWebSocketServerProtocol;
import com.iteaj.iot.websocket.HttpRequestWrapper;
import com.iteaj.iot.websocket.WebSocketFilter;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Optional;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class WebsocketDebugListener
implements WebSocketServerListener,
WebSocketFilter<DefaultWebSocketServerComponent> {
    private final DebugHandleFactory handleFactory;
    private final ThreadPoolTaskScheduler iotTaskScheduler;

    public WebsocketDebugListener(DebugHandleFactory handleFactory, ThreadPoolTaskScheduler iotTaskScheduler) {
        this.handleFactory = handleFactory;
        this.iotTaskScheduler = iotTaskScheduler;
    }

    public String uri() {
        return "/ws/iot/debug";
    }

    public void onText(DefaultWebSocketServerProtocol protocol) {
        HttpRequestWrapper request = ((DefaultWebSocketServerMessage)protocol.requestMessage()).request();
        Optional type = request.getQueryParam("type");
        if (type.isPresent()) {
            Optional handle = this.handleFactory.getHandle((String)type.get());
            if (handle.isPresent()) {
                DebugHandle debugHandle = (DebugHandle)handle.get();
                DebugRequestModel parse = debugHandle.parse(protocol.readText());
                this.iotTaskScheduler.execute(() -> debugHandle.handle(parse.getModel(), new DebugWebsocketWrite(parse.getClientSn())));
            } else {
                protocol.response(JSON.toJSONString((Object)HttpResult.Fail((String)("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5904\u7406\u5668[" + (String)type.get() + "]"))));
            }
        } else {
            protocol.response(JSON.toJSONString((Object)HttpResult.Fail((String)"\u672a\u6307\u5b9a\u8c03\u8bd5\u7c7b\u578b[type]")));
        }
    }

    public void onClose(DefaultWebSocketServerProtocol protocol) {
    }

    public void onBinary(DefaultWebSocketServerProtocol protocol) {
    }

    public Message.MessageHead register(Message.MessageHead head, RegisterParams params) {
        HttpRequestWrapper value = (HttpRequestWrapper)params.getValue(CoreConst.WEBSOCKET_REQ);
        value.getQueryParam("clientSn").ifPresent(clientSn -> head.setEquipCode(clientSn));
        return head;
    }

    public HttpResponseStatus authentication(HttpRequest request) {
        return HttpResponseStatus.OK;
    }
}

