/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.lcd.controller;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.iteaj.framework.BaseController;
import com.iteaj.framework.BaseEntity;
import com.iteaj.framework.result.ListResult;
import com.iteaj.framework.result.Result;
import com.iteaj.framework.spi.admin.DictResource;
import com.iteaj.framework.spi.admin.ResourceManager;
import com.iteaj.iboot.msn.lcd.LowCodeProperties;
import com.iteaj.iboot.msn.lcd.design.DesignReviewVelocityTemplateEngine;
import com.iteaj.iboot.msn.lcd.design.LcdDtoInjectionConfig;
import com.iteaj.iboot.msn.lcd.design.LcdVelocityTemplateEngine;
import com.iteaj.iboot.msn.lcd.design.LcdVelocityVueTemplateZipEngine;
import com.iteaj.iboot.msn.lcd.design.LcdVueInjectionConfig;
import com.iteaj.iboot.msn.lcd.dto.GenConfigDto;
import com.iteaj.iboot.msn.lcd.dto.ReviewDto;
import com.iteaj.iboot.msn.lcd.entity.LcdDesign;
import com.iteaj.iboot.msn.lcd.gen.DesignConfigBuilder;
import com.iteaj.iboot.msn.lcd.service.ILcdDesignService;
import com.iteaj.util.CommonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/lcd/online"})
public class DesignGeneratorController
extends BaseController {
    private final ResourceManager resourceManager;
    private final LowCodeProperties properties;
    private final ILcdDesignService lcdDesignService;

    public DesignGeneratorController(ResourceManager resourceManager, LowCodeProperties properties, ILcdDesignService lcdDesignService) {
        this.resourceManager = resourceManager;
        this.properties = properties;
        this.lcdDesignService = lcdDesignService;
    }

    @GetMapping(value={"dictType"})
    public Result<List<DictResource>> dictType() {
        return this.success(this.resourceManager.getDictResources());
    }

    @PostMapping(value={"java"})
    public Result<Boolean> generator(@RequestBody GenConfigDto dto) {
        if (CollectionUtils.isEmpty(dto.getTables())) {
            return this.fail("\u8bf7\u9009\u62e9\u8981\u751f\u6210\u7684\u8868");
        }
        GlobalConfig globalConfig = new GlobalConfig();
        BeanUtils.copyProperties((Object)((Object)this.properties.getLgc()), (Object)globalConfig);
        globalConfig.setOutputDir(dto.getOutDir());
        globalConfig.setFileOverride(dto.isFileOverride());
        DesignConfigBuilder configBuilder = new DesignConfigBuilder(this.properties.getLpc(), this.properties.getLdc(), this.properties.getLsc(), new TemplateConfig(), globalConfig, dto.getTables());
        configBuilder.setInjectionConfig(new LcdDtoInjectionConfig(configBuilder));
        new LcdVelocityTemplateEngine().init(this.pretreatmentConfigBuilder(configBuilder)).mkdirs().batchOutput().open();
        return this.success(true);
    }

    @PostMapping(value={"vue"})
    public Result<byte[]> download(@RequestBody GenConfigDto dto) throws IOException {
        if (!CommonUtils.isNotEmpty(dto.getTables())) {
            return this.fail("\u8bf7\u9009\u62e9\u751f\u6210\u7684\u8868");
        }
        DesignConfigBuilder configBuilder = new DesignConfigBuilder(this.properties.getLpc(), this.properties.getLdc(), this.properties.getLsc(), new TemplateConfig(), this.properties.getLgc(), dto.getTables());
        configBuilder.setInjectionConfig(new LcdVueInjectionConfig(configBuilder, this.properties));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new LcdVelocityVueTemplateZipEngine(outputStream, this.properties).init(this.pretreatmentConfigBuilder(configBuilder)).mkdirs().batchOutput();
        return this.success(outputStream.toByteArray());
    }

    @PostMapping(value={"tables"})
    public Result<Map<String, Integer>> tables(@RequestBody GenConfigDto dto) {
        ListResult listResult = this.lcdDesignService.list((Wrapper)Wrappers.lambdaQuery().select(new SFunction[]{LcdDesign::getSqlScript, BaseEntity::getId, LcdDesign::getTableName}).in(LcdDesign::getTableName, dto.getTables()));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (!listResult.isEmpty()) {
            map.put("errorNum", 0);
            map.put("successNum", 0);
            Connection conn = this.properties.getLdc().getConn();
            try (Statement statement = conn.createStatement();){
                listResult.forEach(item -> {
                    try {
                        int status = statement.executeUpdate(item.getSqlScript());
                        if (status == 1) {
                            map.put("successNum", (Integer)map.get("successNum") + 1);
                        } else {
                            map.put("errorNum", (Integer)map.get("errorNum") + 1);
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.success(map);
    }

    @GetMapping(value={"review"})
    public Result<ReviewDto> review(String tableName) {
        if (CommonUtils.isBlank((String)tableName)) {
            return this.fail("\u8bf7\u6307\u5b9a\u8981\u9884\u89c8\u7684\u8868");
        }
        DesignConfigBuilder configBuilder = new DesignConfigBuilder(this.properties.getLpc(), this.properties.getLdc(), this.properties.getLsc(), new TemplateConfig().setEntity("/templates/lcd.entity.java"), this.properties.getLgc(), Arrays.asList(tableName));
        DesignReviewVelocityTemplateEngine engine = new DesignReviewVelocityTemplateEngine(this.properties);
        engine.init(this.pretreatmentConfigBuilder(configBuilder)).mkdirs().batchOutput();
        return this.success(engine.getReviewDto());
    }

    protected DesignConfigBuilder pretreatmentConfigBuilder(DesignConfigBuilder config) {
        List<TableInfo> tableList = config.getTableInfoList();
        for (TableInfo tableInfo : tableList) {
            if (config.getGlobalConfig().isActiveRecord()) {
                tableInfo.setImportPackages(Model.class.getCanonicalName());
            }
            if (tableInfo.isConvert()) {
                tableInfo.setImportPackages(TableName.class.getCanonicalName());
            }
            if (config.getStrategyConfig().getLogicDeleteFieldName() != null && tableInfo.isLogicDelete(config.getStrategyConfig().getLogicDeleteFieldName())) {
                tableInfo.setImportPackages(TableLogic.class.getCanonicalName());
            }
            if (StringUtils.isNotBlank((CharSequence)config.getStrategyConfig().getVersionFieldName())) {
                tableInfo.setImportPackages(Version.class.getCanonicalName());
            }
            boolean importSerializable = true;
            if (StringUtils.isNotBlank((CharSequence)config.getStrategyConfig().getSuperEntityClass())) {
                tableInfo.setImportPackages(config.getStrategyConfig().getSuperEntityClass());
                importSerializable = false;
            }
            if (config.getGlobalConfig().isActiveRecord()) {
                importSerializable = true;
            }
            if (importSerializable) {
                tableInfo.setImportPackages(Serializable.class.getCanonicalName());
            }
            if (!config.getStrategyConfig().isEntityBooleanColumnRemoveIsPrefix() || !com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)tableInfo.getFields())) continue;
            List<TableField> tableFields = tableInfo.getFields().stream().filter(field -> "boolean".equalsIgnoreCase(field.getPropertyType())).filter(field -> field.getPropertyName().startsWith("is")).collect(Collectors.toList());
            tableFields.forEach(field -> {
                if (field.isKeyFlag()) {
                    tableInfo.setImportPackages(TableId.class.getCanonicalName());
                } else {
                    tableInfo.setImportPackages(com.baomidou.mybatisplus.annotation.TableField.class.getCanonicalName());
                }
                field.setConvert(true);
                field.setPropertyName(StringUtils.removePrefixAfterPrefixToLower((String)field.getPropertyName(), (int)2));
            });
        }
        return config.setTableInfoList(tableList);
    }
}

