/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.common;

import com.iteaj.framework.exception.ServiceException;
import com.iteaj.framework.result.HttpResult;
import com.iteaj.framework.result.Result;
import com.iteaj.framework.spi.auth.SecurityException;
import java.util.List;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.shiro.ShiroException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class IBootControllerAdvice {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={Throwable.class})
    protected <E> Result<E> exceptionHandle(Throwable e) {
        this.logger.error("\u672a\u77e5\u9519\u8bef", (Object)e.getMessage(), (Object)e);
        return Result.fail((String)"\u7cfb\u7edf\u5f02\u5e38");
    }

    @ExceptionHandler(value={ShiroException.class})
    protected Result shiroExceptionHandle(ShiroException e) {
        if (e instanceof UnauthorizedException) {
            return Result.fail((String)"\u60a8\u65e0\u6b64\u529f\u80fd\u6743\u9650");
        }
        if (e instanceof AuthenticationException) {
            return Result.fail((String)"\u8bf7\u5148\u8ba4\u8bc1");
        }
        return Result.fail((String)"\u672a\u8ba4\u8bc1\u6216\u8005\u65e0\u6b64\u6743\u9650");
    }

    @ExceptionHandler(value={ServiceException.class})
    protected <E> Result<E> serviceHandle(ServiceException e) {
        this.logger.error("\u4e1a\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
        return HttpResult.Fail((String)e.getMessage());
    }

    @ExceptionHandler(value={SecurityException.class})
    protected <E> Result<E> securityHandle(SecurityException e) {
        this.logger.error("\u8ba4\u8bc1\u6388\u6743\u5931\u8d25", (Throwable)e);
        return HttpResult.Fail((String)e.getMessage());
    }

    @ExceptionHandler(value={BindException.class})
    public Result bindExceptionHandler(BindException e) {
        List fieldErrors = e.getBindingResult().getFieldErrors();
        return HttpResult.Fail((String)((FieldError)fieldErrors.get(0)).getDefaultMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result methodArgumentNotValidExceptionHandler(MethodArgumentNotValidException e) {
        List fieldErrors = e.getBindingResult().getFieldErrors();
        return HttpResult.Fail((String)((FieldError)fieldErrors.get(0)).getDefaultMessage());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result constraintViolationExceptionHandler(ConstraintViolationException e) {
        ConstraintViolation violation = (ConstraintViolation)e.getConstraintViolations().stream().findFirst().get();
        return HttpResult.Fail((String)violation.getMessage());
    }
}

