/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.core.config.listener;

import com.iteaj.framework.Entity;
import com.iteaj.framework.spi.admin.event.OnlinePayload;
import com.iteaj.framework.spi.admin.event.OnlineStatus;
import com.iteaj.framework.spi.event.FrameworkListener;
import com.iteaj.framework.spi.event.PayloadEvent;
import com.iteaj.iboot.msn.core.entity.Admin;
import com.iteaj.iboot.msn.core.entity.OnlineUser;
import com.iteaj.iboot.msn.core.enums.ClientType;
import com.iteaj.iboot.msn.core.service.IOnlineUserService;
import eu.bitwalker.useragentutils.DeviceType;
import eu.bitwalker.useragentutils.UserAgent;
import java.util.Date;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class OnlineUserListener
implements FrameworkListener<PayloadEvent<OnlinePayload>> {
    private final IOnlineUserService service;

    public OnlineUserListener(IOnlineUserService service) {
        this.service = service;
    }

    @Async
    public void onApplicationEvent(PayloadEvent<OnlinePayload> event) {
        OnlinePayload payload = (OnlinePayload)event.getPayload();
        OnlineStatus type = payload.getType();
        OnlineUser onlineUser = new OnlineUser(payload.getSessionId());
        if (type == OnlineStatus.Online) {
            Admin admin = (Admin)payload.getUser();
            UserAgent agent = payload.getUserAgent();
            String browse = agent.getBrowser().getName();
            String os = agent.getOperatingSystem().getName();
            DeviceType deviceType = agent.getOperatingSystem().getDeviceType();
            ClientType clientType = ClientType.valueOf((String)deviceType.name());
            onlineUser.setLoginTime(new Date()).setOs(os).setStatus(type).setBrowse(browse).setType(clientType).setUserNick(admin.getName()).setAccount(admin.getAccount()).setAccessIp(payload.getAccessIp()).setExpireTime(Long.valueOf(payload.getExpireTime()));
            this.service.save((Entity)onlineUser);
        } else if (type == OnlineStatus.Offline) {
            this.service.updateBySessionId(onlineUser.setStatus(type).setUpdateTime(new Date()));
        }
    }
}

