/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.iteaj.framework.BaseServiceImpl;
import com.iteaj.framework.Entity;
import com.iteaj.framework.exception.ServiceException;
import com.iteaj.framework.result.BooleanResult;
import com.iteaj.framework.result.DetailResult;
import com.iteaj.framework.result.ListResult;
import com.iteaj.iboot.msn.core.dto.RoleDto;
import com.iteaj.iboot.msn.core.entity.Role;
import com.iteaj.iboot.msn.core.mapper.IRoleDao;
import com.iteaj.iboot.msn.core.service.IRoleService;
import com.iteaj.util.CommonUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleServiceImpl
extends BaseServiceImpl<IRoleDao, Role>
implements IRoleService {
    public BooleanResult updateById(Role entity) {
        this.getOne((Wrapper)Wrappers.lambdaQuery().eq(Role::getName, (Object)entity.getName())).ofNullable().ifPresent(item -> {
            if (item.getId().compareTo(entity.getId()) != 0) {
                throw new ServiceException("\u89d2\u8272\u540d\u79f0\u91cd\u590d[" + entity.getName() + "]");
            }
        });
        return super.updateById((Entity)entity);
    }

    @Transactional
    public void delRoleAndPermByIds(List<Long> list) {
        if (CommonUtils.isNotEmpty(list)) {
            if (list.size() > 1) {
                throw new ServiceException("\u4e0d\u652f\u6301\u6279\u91cf\u5220\u9664");
            }
            List adminIds = this.listBindAdminOfRole(list.get(0));
            if (CommonUtils.isNotEmpty((Collection)adminIds)) {
                throw new ServiceException("\u6b64\u89d2\u8272\u5df2\u88ab\u4f7f\u7528");
            }
        } else {
            throw new ServiceException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u89d2\u8272");
        }
        ((IRoleDao)this.getBaseMapper()).deleteAllJoinByIds(list);
    }

    public DetailResult<RoleDto> detail(Long id) {
        return new DetailResult((Entity)((IRoleDao)this.getBaseMapper()).joinRoleMenuById(id));
    }

    public void createRoleAndPerms(RoleDto role) {
        this.getOne((Wrapper)Wrappers.lambdaQuery().eq(Role::getName, (Object)role.getName())).ofNullable().ifPresent(item -> {
            throw new ServiceException("\u89d2\u8272\u540d\u79f0\u91cd\u590d[" + role.getName() + "]");
        });
        ((IRoleDao)this.getBaseMapper()).createRoleAndPerms(role);
    }

    public void updateRolePermsById(RoleDto role) {
        if (!CommonUtils.isNotEmpty((Collection)role.getMenuIds())) {
            throw new ServiceException("\u8bf7\u9009\u62e9\u6743\u9650");
        }
        this.getOne((Wrapper)Wrappers.lambdaQuery().eq(Role::getName, (Object)role.getName())).ofNullable().ifPresent(item -> {
            if (role.getId().compareTo(item.getId()) != 0) {
                throw new ServiceException("\u89d2\u8272\u540d\u79f0\u91cd\u590d[" + role.getName() + "]");
            }
        });
        ((IRoleDao)this.getBaseMapper()).updateRolePermsById((Role)role);
    }

    public List<Long> selectByAdminId(Serializable id) {
        return ((IRoleDao)this.getBaseMapper()).selectByAdminId(id);
    }

    public ListResult<Long> listMenusOfRole(Long roleId) {
        if (roleId == null) {
            return new ListResult(Collections.EMPTY_LIST);
        }
        return new ListResult(((IRoleDao)this.getBaseMapper()).listMenusOfRole(roleId));
    }

    public List<Long> listBindAdminOfRole(Long roleId) {
        return ((IRoleDao)this.getBaseMapper()).listBindAdminOfRole(roleId);
    }
}

