/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.collect.action;

import com.iteaj.iboot.msn.iot.collect.CollectException;
import com.iteaj.iboot.msn.iot.collect.action.CollectAction;
import com.iteaj.iboot.msn.iot.debug.dtu.DtuDebugHandle;
import com.iteaj.iboot.msn.iot.dto.CollectTaskDto;
import com.iteaj.iboot.msn.iot.dto.DeviceDto;
import com.iteaj.iboot.msn.iot.entity.CollectDetail;
import com.iteaj.iboot.msn.iot.entity.Signal;
import com.iteaj.iot.ProtocolException;
import com.iteaj.iot.consts.ExecStatus;
import com.iteaj.iot.modbus.ModbusCommonProtocol;
import com.iteaj.iot.modbus.Payload;
import com.iteaj.iot.server.protocol.ServerInitiativeSyncProtocol;
import com.iteaj.iot.utils.ByteUtil;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.springframework.util.StringUtils;

public abstract class AbstractModbusCollectAction
extends CollectAction {
    public void validate(Signal signal) {
        super.validate(signal);
    }

    public void validate(CollectDetail detail) {
        super.validate(detail);
        if (!StringUtils.hasText((String)detail.getChildSn())) {
            throw new CollectException("\u672a\u914d\u7f6e\u5b50\u8bbe\u5907\u7f16\u53f7");
        }
    }

    protected void doExec(CollectTaskDto taskDto, CollectDetail detail, Signal signal, Consumer<String> call) {
        Integer type = signal.getFieldType();
        DeviceDto device = detail.getDevice();
        Integer childSn = Integer.valueOf(detail.getChildSn());
        Integer address = Integer.valueOf(signal.getAddress());
        ModbusCommonProtocol commonProtocol = this.getModbusCommonProtocol(type, device.getDeviceSn(), childSn, address, signal.getNum());
        ServerInitiativeSyncProtocol syncProtocol = (ServerInitiativeSyncProtocol)commonProtocol;
        try {
            syncProtocol.request();
        }
        catch (ProtocolException e) {
            throw new CollectException(e.getMessage());
        }
        if (syncProtocol.getExecStatus() != ExecStatus.success) {
            throw new CollectException(syncProtocol.getExecStatus().desc);
        }
        Object value = this.resolveValue(signal.getNum(), type, address, commonProtocol.getPayload());
        call.accept(value.toString());
    }

    protected Object resolveValue(Integer num, Integer type, Integer address, Payload payload) {
        Object value;
        switch (type) {
            case 7: {
                value = payload.readBoolean(address.intValue());
                break;
            }
            case 2: {
                value = payload.readShort(address.intValue());
                break;
            }
            case 3: {
                value = payload.readInt(address.intValue());
                break;
            }
            case 5: {
                value = Float.valueOf(payload.readFloat(address.intValue()));
                break;
            }
            case 6: {
                value = payload.readDouble(address.intValue());
                break;
            }
            case 4: {
                value = payload.readLong(address.intValue());
                break;
            }
            case 9: {
                value = payload.readString(address.intValue(), num.intValue());
                break;
            }
            case 11: {
                ByteBuffer buf = ByteBuffer.allocateDirect(4);
                buf.put(DtuDebugHandle.byteReverse((byte[])payload.getPayload()));
                buf.rewind();
                value = buf.getInt();
                break;
            }
            case 12: {
                ByteBuffer buff = ByteBuffer.allocateDirect(4);
                buff.put(DtuDebugHandle.byteReverse((byte[])payload.getPayload()));
                buff.rewind();
                value = Float.valueOf(buff.getFloat());
                break;
            }
            default: {
                value = ByteUtil.bytesToHex((byte[])payload.getPayload());
            }
        }
        return value;
    }

    protected abstract ModbusCommonProtocol getModbusCommonProtocol(Integer var1, String var2, Integer var3, Integer var4, Integer var5);
}

