/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.collect.action;

import com.iteaj.iboot.msn.iot.collect.CollectException;
import com.iteaj.iboot.msn.iot.collect.action.CollectAction;
import com.iteaj.iboot.msn.iot.dto.CollectTaskDto;
import com.iteaj.iboot.msn.iot.dto.DeviceDto;
import com.iteaj.iboot.msn.iot.entity.CollectDetail;
import com.iteaj.iboot.msn.iot.entity.Signal;
import com.iteaj.iot.client.ClientConnectProperties;
import com.iteaj.iot.consts.ExecStatus;
import com.iteaj.iot.plc.siemens.SiemensConnectProperties;
import com.iteaj.iot.plc.siemens.SiemensModel;
import com.iteaj.iot.plc.siemens.SiemensS7Protocol;
import java.util.function.Consumer;
import org.springframework.util.StringUtils;

public class SiemensCollectAction
extends CollectAction {
    public String getName() {
        return "PLC:SIEMENS";
    }

    public String getDesc() {
        return "\u897f\u95e8\u5b50PLC\u91c7\u96c6\u5668";
    }

    public void validate(Signal signal) {
        super.validate(signal);
    }

    public void validate(CollectDetail detail) {
        super.validate(detail);
        DeviceDto device = detail.getDevice();
        if (StringUtils.hasText((String)device.getIp()) || device.getPort() == null) {
            throw new CollectException("PLC\u8bbe\u5907[" + detail.getDeviceSn() + "]\u6ca1\u6709\u6307\u5b9aip\u6216\u8005\u7aef\u53e3\u53f7");
        }
        try {
            SiemensModel.valueOf((String)device.getModelName());
        }
        catch (Exception e) {
            throw new CollectException("\u897f\u95e8\u5b50\u8bbe\u5907[" + detail.getDeviceSn() + "]\u578b\u53f7\u9519\u8bef[" + device.getModelName() + "]");
        }
    }

    protected void doExec(CollectTaskDto taskDto, CollectDetail detail, Signal signal, Consumer<String> call) {
        Object value = "";
        String address = signal.getAddress();
        DeviceDto device = detail.getDevice();
        SiemensModel model = SiemensModel.valueOf((String)device.getModelName());
        SiemensS7Protocol protocol = new SiemensS7Protocol((ClientConnectProperties)new SiemensConnectProperties(device.getIp(), device.getPort(), model));
        Integer fieldType = signal.getFieldType();
        switch (fieldType) {
            case 1: {
                break;
            }
            case 2: {
                value = protocol.readInt16(address);
                break;
            }
            case 3: {
                value = protocol.readInt32(address);
                break;
            }
            case 4: {
                value = protocol.readInt64(address);
                break;
            }
            case 5: {
                value = protocol.readFloat(address);
                break;
            }
            case 6: {
                value = protocol.readDouble(address);
                break;
            }
            case 7: {
                value = protocol.readBool(address);
            }
        }
        if (protocol.getExecStatus() != ExecStatus.success) {
            throw new CollectException(protocol.getExecStatus().desc);
        }
        call.accept(value.toString());
    }
}

