/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.collect.store;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.iteaj.iboot.msn.iot.collect.CollectException;
import com.iteaj.iboot.msn.iot.collect.store.StoreAction;
import com.iteaj.iboot.msn.iot.entity.CollectData;
import com.iteaj.iboot.msn.iot.entity.CollectDetail;
import com.iteaj.iot.Message;
import com.iteaj.iot.ProtocolType;
import com.iteaj.iot.client.ClientConnectProperties;
import com.iteaj.iot.client.mqtt.gateway.MqttGatewayConnectProperties;
import com.iteaj.iot.client.mqtt.gateway.MqttGatewayHead;
import com.iteaj.iot.client.mqtt.gateway.MqttGatewayMessage;
import com.iteaj.iot.client.mqtt.gateway.MqttGatewayProtocol;
import com.iteaj.iot.client.mqtt.gateway.MqttGatewayProtocolType;
import com.iteaj.iot.message.DefaultMessageBody;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.util.List;
import java.util.Map;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.StringUtils;

public class MqttStoreAction
extends StoreAction {
    private static ExpressionParser parser = new SpelExpressionParser();

    public String getName() {
        return "STORE:MQTT";
    }

    public String getDesc() {
        return "MQTT\u670d\u52a1";
    }

    public void configValidate(Map<String, Object> jsonConfig) {
        if (!(jsonConfig.get("topic") instanceof String)) {
            throw new CollectException("\u672a\u914d\u7f6e\u53c2\u6570[topic]");
        }
        if (!(jsonConfig.get("clientId") instanceof String)) {
            throw new CollectException("\u672a\u914d\u7f6e\u53c2\u6570[clientId]");
        }
        if (!(jsonConfig.get("host") instanceof String)) {
            throw new CollectException("\u672a\u914d\u7f6e\u53c2\u6570[host]");
        }
        if (!(jsonConfig.get("port") instanceof Integer)) {
            throw new CollectException("\u672a\u914d\u7f6e\u53c2\u6570[port]");
        }
    }

    public void store(CollectDetail detail, List<CollectData> data) {
        data.forEach(item -> {
            Map config = detail.resolveConfig();
            String topic = (String)parser.parseExpression((String)config.get("topic")).getValue(item, String.class);
            MqttGatewayConnectProperties connectProperties = new MqttGatewayConnectProperties((String)config.get("host"), (Integer)config.get("port"), (String)config.get("clientId"), (String)config.get("topic"));
            if (StringUtils.hasText((String)((String)config.get("username"))) && StringUtils.hasText((String)((String)config.get("password")))) {
                connectProperties.setPassword((String)config.get("password"));
                connectProperties.setUsername((String)config.get("username"));
            }
            MqttGatewayHead head = new MqttGatewayHead((String)config.get("clientId"), null, (ProtocolType)MqttGatewayProtocolType.Mqtt_Gateway);
            DefaultMessageBody body = new DefaultMessageBody(JSONObject.toJSONBytes((Object)item, (SerializerFeature[])new SerializerFeature[0]));
            MqttGatewayMessage gatewayMessage = new MqttGatewayMessage(head, (Message.MessageBody)body, MqttQoS.AT_LEAST_ONCE, topic);
            new MqttGatewayProtocol(gatewayMessage).request((ClientConnectProperties)connectProperties);
        });
    }
}

