/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.collect.store;

import com.iteaj.iboot.msn.iot.collect.CollectOption;
import com.iteaj.iboot.msn.iot.collect.store.StoreAction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class StoreActionFactory
implements InitializingBean {
    @Autowired(required=false)
    private List<StoreAction> actions;
    private Map<String, StoreAction> actionMap = new ConcurrentHashMap(8);
    private static StoreActionFactory actionFactory = new StoreActionFactory();

    protected StoreActionFactory() {
    }

    public static StoreActionFactory getInstance() {
        return actionFactory;
    }

    public StoreAction get(String actionName) {
        if (!StringUtils.hasText((String)actionName)) {
            return null;
        }
        return (StoreAction)this.actionMap.get(actionName);
    }

    public Set<String> getNames() {
        return this.actionMap.keySet();
    }

    public Collection<StoreAction> getActions() {
        return this.actionMap.values();
    }

    public boolean isExists(String actionName) {
        return this.actionMap.containsKey(actionName);
    }

    public StoreAction remove(String actionName) {
        return (StoreAction)this.actionMap.remove(actionName);
    }

    public StoreAction register(String actionName, StoreAction storeAction) {
        return this.actionMap.putIfAbsent(actionName, storeAction);
    }

    public StoreAction register(StoreAction storeAction) {
        return this.actionMap.putIfAbsent(storeAction.getName(), storeAction);
    }

    public List<CollectOption> options() {
        return this.actionMap.values().stream().map(item -> new CollectOption(item.getDesc(), item.getName())).collect(Collectors.toList());
    }

    public void afterPropertiesSet() throws Exception {
        if (!CollectionUtils.isEmpty((Collection)this.actions)) {
            this.actions.forEach(item -> {
                if (this.isExists(item.getName())) {
                    throw new BeanInitializationException("\u5b58\u5728\u76f8\u540c\u7684\u91c7\u96c6\u52a8\u4f5c[" + item.getName() + "]");
                }
                this.register(item);
            });
        }
    }
}

