/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.iteaj.framework.BaseController;
import com.iteaj.framework.BaseEntity;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.DetailResult;
import com.iteaj.framework.result.Result;
import com.iteaj.iboot.msn.iot.consts.DeviceStatus;
import com.iteaj.iboot.msn.iot.consts.DeviceTypeAlias;
import com.iteaj.iboot.msn.iot.dto.DeviceDto;
import com.iteaj.iboot.msn.iot.entity.Device;
import com.iteaj.iboot.msn.iot.service.IDeviceModelService;
import com.iteaj.iboot.msn.iot.service.IDeviceService;
import com.iteaj.iot.client.ClientConnectProperties;
import com.iteaj.iot.client.mqtt.MqttClient;
import com.iteaj.iot.client.mqtt.MqttConnectProperties;
import com.iteaj.iot.client.mqtt.impl.DefaultMqttComponent;
import java.io.Serializable;
import java.util.List;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iot/mqtt"})
public class DeviceMqttController
extends BaseController {
    private final IDeviceService deviceService;
    private final IDeviceModelService deviceModelService;
    private final DefaultMqttComponent defaultMqttComponent;

    public DeviceMqttController(IDeviceService deviceService, IDeviceModelService deviceModelService, @Autowired(required=false) DefaultMqttComponent defaultMqttComponent) {
        this.deviceService = deviceService;
        this.deviceModelService = deviceModelService;
        this.defaultMqttComponent = defaultMqttComponent;
    }

    @GetMapping(value={"/view"})
    @RequiresPermissions(value={"iot:mqtt:view"})
    public Result<IPage<DeviceDto>> list(Page<Device> page, DeviceDto entity) {
        entity.setAlias(DeviceTypeAlias.MQTT);
        return this.deviceService.pageOfDetail(page, entity);
    }

    @GetMapping(value={"/edit"})
    @RequiresPermissions(value={"iot:mqtt:edit"})
    public Result<Device> getEditDetail(Long id) {
        return this.deviceService.getById((Serializable)id);
    }

    @PostMapping(value={"/saveOrUpdate"})
    @RequiresPermissions(value={"iot:mqtt:edit", "iot:mqtt:add"}, logical=Logical.OR)
    public Result<Boolean> save(@RequestBody Device entity) {
        DetailResult one = entity.getId() == null ? this.deviceService.getOne((Wrapper)Wrappers.lambdaQuery().eq(Device::getDeviceSn, (Object)entity.getDeviceSn())) : this.deviceService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Device::getDeviceSn, (Object)entity.getDeviceSn())).ne(BaseEntity::getId, (Object)entity.getId()));
        if (one.getData() != null) {
            return this.fail("\u5df2\u7ecf\u5305\u542b\u6709\u8bbe\u5907[" + entity.getDeviceSn() + "]");
        }
        return this.deviceService.saveOrUpdate((Entity)entity);
    }

    @PostMapping(value={"/del"})
    @RequiresPermissions(value={"iot:mqtt:del"})
    public Result<Boolean> remove(@RequestBody List<Long> idList) {
        return this.deviceService.removeByIds(idList);
    }

    @PostMapping(value={"connect"})
    @RequiresPermissions(value={"iot:mqtt:connect"})
    public Result connect(@RequestBody Device device, DeviceStatus status) {
        if (status == null) {
            return this.fail("\u672a\u6307\u5b9a\u8fde\u63a5\u72b6\u6001");
        }
        if (this.defaultMqttComponent == null) {
            return this.fail("\u6ca1\u6709\u542f\u7528mqtt\u7ec4\u4ef6");
        }
        Device entity = (Device)this.deviceService.getById((Serializable)device.getId()).getData();
        if (entity == null) {
            return this.fail("\u8bbe\u5907\u4e0d\u5b58\u5728[" + device.getDeviceSn() + "]");
        }
        MqttConnectProperties properties = new MqttConnectProperties(entity.getIp(), entity.getPort(), entity.getDeviceSn());
        properties.setUsername(entity.getAccount());
        properties.setPassword(entity.getPassword());
        MqttClient client = this.defaultMqttComponent.getClient((Object)properties);
        if (status == DeviceStatus.online) {
            if (client == null) {
                this.defaultMqttComponent.createNewClientAndConnect((ClientConnectProperties)properties);
            } else {
                client.connect(null, 3000L).syncUninterruptibly();
            }
        } else if (client != null) {
            client.disconnect(false).syncUninterruptibly();
        }
        return this.success();
    }
}

