/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.iteaj.framework.BaseController;
import com.iteaj.framework.BaseEntity;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.DetailResult;
import com.iteaj.framework.result.Result;
import com.iteaj.iboot.msn.iot.consts.DeviceStatus;
import com.iteaj.iboot.msn.iot.consts.DeviceTypeAlias;
import com.iteaj.iboot.msn.iot.dto.DeviceDto;
import com.iteaj.iboot.msn.iot.entity.Device;
import com.iteaj.iboot.msn.iot.entity.DeviceModel;
import com.iteaj.iboot.msn.iot.service.IDeviceModelService;
import com.iteaj.iboot.msn.iot.service.IDeviceService;
import com.iteaj.iot.client.ClientConnectProperties;
import com.iteaj.iot.client.SocketClient;
import com.iteaj.iot.plc.omron.OmronComponent;
import com.iteaj.iot.plc.omron.OmronConnectProperties;
import com.iteaj.iot.plc.siemens.SiemensConnectProperties;
import com.iteaj.iot.plc.siemens.SiemensModel;
import com.iteaj.iot.plc.siemens.SiemensS7Component;
import java.io.Serializable;
import java.util.List;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iot/plc"})
public class DevicePlcController
extends BaseController {
    private final IDeviceService deviceService;
    private final OmronComponent omronComponent;
    private final IDeviceModelService deviceModelService;
    private final SiemensS7Component siemensS7Component;

    public DevicePlcController(IDeviceService deviceService, OmronComponent omronComponent, IDeviceModelService deviceModelService, SiemensS7Component siemensS7Component) {
        this.deviceService = deviceService;
        this.omronComponent = omronComponent;
        this.deviceModelService = deviceModelService;
        this.siemensS7Component = siemensS7Component;
    }

    @GetMapping(value={"/view"})
    @RequiresPermissions(value={"iot:plc:view"})
    public Result<IPage<DeviceDto>> list(Page<Device> page, DeviceDto entity) {
        entity.setAlias(DeviceTypeAlias.PLC);
        return this.deviceService.pageOfDetail(page, entity);
    }

    @GetMapping(value={"/edit"})
    @RequiresPermissions(value={"iot:plc:edit"})
    public Result<Device> getEditDetail(Long id) {
        return this.deviceService.getById((Serializable)id);
    }

    @PostMapping(value={"/saveOrUpdate"})
    @RequiresPermissions(value={"iot:plc:edit", "iot:plc:add"}, logical=Logical.OR)
    public Result<Boolean> save(@RequestBody Device entity) {
        DetailResult one = entity.getId() == null ? this.deviceService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Device::getIp, (Object)entity.getIp())).eq(Device::getPort, (Object)entity.getPort())) : this.deviceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Device::getIp, (Object)entity.getIp())).ne(BaseEntity::getId, (Object)entity.getId())).eq(Device::getPort, (Object)entity.getPort()));
        if (one.getData() != null) {
            return this.fail("\u5df2\u7ecf\u5305\u542b\u6709\u8bbe\u5907[" + entity.getIp() + ":" + entity.getPort() + "]");
        }
        return this.deviceService.saveOrUpdate((Entity)entity);
    }

    @PostMapping(value={"/del"})
    @RequiresPermissions(value={"iot:plc:del"})
    public Result<Boolean> remove(@RequestBody List<Long> idList) {
        return this.deviceService.removeByIds(idList);
    }

    @PostMapping(value={"connect"})
    @RequiresPermissions(value={"iot:plc:connect"})
    public Result connect(@RequestBody Device device, DeviceStatus status) {
        if (status == null) {
            return this.fail("\u672a\u6307\u5b9a\u8fde\u63a5\u72b6\u6001");
        }
        Device entity = (Device)this.deviceService.getById((Serializable)device.getId()).getData();
        if (entity == null) {
            return this.fail("\u8bbe\u5907\u4e0d\u5b58\u5728[" + device.getDeviceSn() + "]");
        }
        DeviceModel data = (DeviceModel)this.deviceModelService.getById((Serializable)entity.getModel()).getData();
        if (data == null) {
            return this.fail("\u9519\u8bef\u7684\u8bbe\u5907\u578b\u53f7");
        }
        try {
            if (device.getDeviceTypeId() == 2L) {
                SiemensModel model = SiemensModel.valueOf((String)data.getModel());
                SiemensConnectProperties properties = new SiemensConnectProperties(device.getIp(), device.getPort(), model, entity.getDeviceSn());
                SocketClient client = this.siemensS7Component.getClient((Object)properties);
                if (status == DeviceStatus.online) {
                    if (client == null) {
                        this.siemensS7Component.createNewClientAndConnect((ClientConnectProperties)properties);
                    } else {
                        client.reconnection();
                    }
                } else {
                    client.disconnect(false);
                }
            } else if (device.getDeviceTypeId() == 3L) {
                OmronConnectProperties properties = new OmronConnectProperties(device.getIp(), device.getPort());
                properties.setConnectKey(entity.getDeviceSn());
                SocketClient client = this.omronComponent.getClient((Object)properties);
                if (status == DeviceStatus.online) {
                    if (client == null) {
                        this.omronComponent.createNewClientAndConnect((ClientConnectProperties)properties);
                    } else {
                        client.connect(null, 3000L);
                    }
                } else {
                    client.disconnect(false);
                }
            }
            return this.success(status == DeviceStatus.online ? "\u8fde\u63a5\u6210\u529f" : "\u65ad\u5f00\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.fail(e.getMessage());
        }
    }
}

