/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.iteaj.framework.BaseController;
import com.iteaj.framework.BaseEntity;
import com.iteaj.framework.Entity;
import com.iteaj.framework.result.Result;
import com.iteaj.iboot.msn.iot.collect.CollectOption;
import com.iteaj.iboot.msn.iot.consts.SerialStatus;
import com.iteaj.iboot.msn.iot.entity.Serial;
import com.iteaj.iboot.msn.iot.service.ISerialService;
import com.iteaj.iot.client.ClientConnectProperties;
import com.iteaj.iot.client.IotClient;
import com.iteaj.iot.serial.SerialClient;
import com.iteaj.iot.serial.SerialComponent;
import com.iteaj.iot.serial.SerialConnectProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iot/serial"})
public class SerialController
extends BaseController {
    private final ISerialService serialService;

    public SerialController(ISerialService serialService) {
        this.serialService = serialService;
    }

    @GetMapping(value={"/view"})
    @RequiresPermissions(value={"iot:serial:view"})
    public Result<IPage<Serial>> list(Page<Serial> page, Serial entity) {
        return this.serialService.page(page, (Entity)entity);
    }

    @GetMapping(value={"/list"})
    public Result<List<Serial>> list(Serial entity) {
        return this.serialService.list((Entity)entity);
    }

    @GetMapping(value={"/edit"})
    @RequiresPermissions(value={"iot:serial:edit"})
    public Result<Serial> getById(Long id) {
        return this.serialService.getById((Serializable)id);
    }

    @GetMapping(value={"/getByCom"})
    public Result<Serial> getByCom(String com) {
        return this.serialService.getByCom(com);
    }

    @PostMapping(value={"/saveOrUpdate"})
    @RequiresPermissions(value={"iot:serial:edit", "iot:serial:add"}, logical=Logical.OR)
    public Result<Boolean> save(@RequestBody Serial entity) {
        return this.serialService.saveOrUpdate((Entity)entity);
    }

    @PostMapping(value={"/del"})
    @RequiresPermissions(value={"iot:serial:del"})
    public Result<Boolean> remove(@RequestBody List<Long> idList) {
        return this.serialService.removeByIds(idList);
    }

    @GetMapping(value={"/available"})
    public Result<List<CollectOption>> available() {
        List collect = Arrays.stream(SerialComponent.instance().available()).map(item -> {
            String portName = item.getSystemPortName();
            return new CollectOption(portName, portName);
        }).collect(Collectors.toList());
        return this.success(collect);
    }

    @PostMapping(value={"connect/{status}"})
    @RequiresPermissions(value={"iot:serial:connect"})
    public Result<Boolean> connect(@RequestBody Serial device, @PathVariable SerialStatus status) {
        SerialClient client = SerialComponent.instance().getClient((Object)device.getCom());
        if (status == SerialStatus.open) {
            if (client == null) {
                SerialConnectProperties config = new SerialConnectProperties(device.getCom(), device.getBaudRate().intValue()).config(device.getDataBits().intValue(), device.getStopBits().intValue(), device.getParity().intValue());
                client = SerialComponent.instance().createNewClient((ClientConnectProperties)config);
                client.init(null);
                SerialComponent.instance().addClient((Object)device.getCom(), (IotClient)client);
            }
            if (client.open()) {
                this.serialService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(Serial::getStatus, (Object)status)).eq(BaseEntity::getId, (Object)device.getId()));
                return this.success("\u6253\u5f00\u4e32\u53e3\u6210\u529f");
            }
            return this.fail("\u4e32\u53e3\u672a\u6302\u8f7d\u6216\u88ab\u6682\u7528");
        }
        if (client != null && client.isOpen()) {
            this.serialService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(Serial::getStatus, (Object)status)).eq(BaseEntity::getId, (Object)device.getId()));
            return this.success((Object)client.disconnect(false));
        }
        this.serialService.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(Serial::getStatus, (Object)status)).eq(BaseEntity::getId, (Object)device.getId()));
        return this.success("\u5173\u95ed\u4e32\u53e3\u6210\u529f");
    }
}

