/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.debug.dtu;

import com.iteaj.framework.result.HttpResult;
import com.iteaj.iboot.msn.iot.debug.DebugHandle;
import com.iteaj.iboot.msn.iot.debug.DebugModel;
import com.iteaj.iboot.msn.iot.debug.DebugResult;
import com.iteaj.iboot.msn.iot.debug.DebugWebsocketWrite;
import com.iteaj.iboot.msn.iot.debug.dtu.DtuDebugModel;
import com.iteaj.iboot.msn.iot.debug.dtu.Hex2Float;
import com.iteaj.iboot.msn.iot.debug.dtu.NumberFormatException;
import com.iteaj.iot.Message;
import com.iteaj.iot.ProtocolException;
import com.iteaj.iot.consts.ExecStatus;
import com.iteaj.iot.modbus.ModbusCommonProtocol;
import com.iteaj.iot.modbus.Payload;
import com.iteaj.iot.modbus.ReadPayload;
import com.iteaj.iot.modbus.RealCoilPayload;
import com.iteaj.iot.modbus.consts.ModbusCoilStatus;
import com.iteaj.iot.modbus.server.dtu.ModbusRtuForDtuCommonProtocol;
import com.iteaj.iot.modbus.server.dtu.ModbusTcpForDtuCommonProtocol;
import com.iteaj.iot.modbus.server.rtu.ModbusRtuBody;
import com.iteaj.iot.modbus.server.tcp.ModbusTcpBody;
import com.iteaj.iot.server.ServerMessage;
import com.iteaj.iot.server.dtu.impl.CommonDtuProtocol;
import com.iteaj.iot.server.protocol.ServerInitiativeProtocol;
import com.iteaj.iot.utils.ByteUtil;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DtuDebugHandle
implements DebugHandle<DtuDebugModel> {
    public String type() {
        return "dtu";
    }

    public void handle(DtuDebugModel model, DebugWebsocketWrite write) {
        String deviceSn = model.getDeviceSn();
        if (!StringUtils.hasText((String)deviceSn)) {
            write.write(HttpResult.Fail((String)"\u672a\u6307\u5b9a\u8bbe\u5907\u7f16\u53f7[deviceSn]"));
            return;
        }
        try {
            String protocolType = model.getProtocolType();
            if (!StringUtils.hasText((String)protocolType)) {
                write.write(HttpResult.Fail((String)"\u8bf7\u6307\u5b9a\u534f\u8bae\u7c7b\u578b[protocolType]"));
            } else {
                switch (protocolType) {
                    case "tcp": {
                        this.modbusTcpHandle(model, write);
                        break;
                    }
                    case "rtu": {
                        this.modbusRtuHandle(model, write);
                        break;
                    }
                    case "cus": {
                        this.otherHandleforsb(model, write);
                        break;
                    }
                    default: {
                        write.write(HttpResult.Fail((String)("\u4e0d\u652f\u6301\u7684\u534f\u8bae\u7c7b\u578b[" + protocolType + "]")));
                    }
                }
            }
        }
        catch (Exception e) {
            write.write(HttpResult.Fail((String)e.getMessage()));
        }
    }

    private void otherHandle(DtuDebugModel model, DebugWebsocketWrite write) {
        String message = model.getMessage();
        if (!StringUtils.hasText((String)message)) {
            write.write(HttpResult.Fail((String)"\u672a\u6307\u5b9a\u8981\u53d1\u9001\u7684\u62a5\u6587"));
            return;
        }
        String cmd = model.getCmd();
        if (!StringUtils.hasText((String)cmd)) {
            write.write(HttpResult.Fail((String)"\u672a\u6307\u5b9a\u64cd\u4f5c\u6307\u4ee4"));
            return;
        }
        try {
            byte[] bytes;
            try {
                bytes = ByteUtil.hexToByte((String)message);
            }
            catch (Exception e) {
                write.write(HttpResult.Fail((String)"\u53ea\u652f\u630116\u8fdb\u5236\u62a5\u6587\u683c\u5f0f"));
                return;
            }
            DebugResult result = new DebugResult((DebugModel)model).setDeviceSn(model.getDeviceSn()).setReqTime(System.currentTimeMillis()).setReqMsg(ByteUtil.bytesToHexByFormat((byte[])bytes));
            byte[] respMsg = new byte[]{};
            CommonDtuProtocol protocol = new CommonDtuProtocol(model.getDeviceSn());
            if ("read".equals(cmd)) {
                respMsg = protocol.read(bytes);
            } else if ("write".equals(cmd)) {
                respMsg = protocol.write(bytes);
            } else if ("writeOfAsync".equals(cmd)) {
                protocol.writeOfAsync(bytes);
            } else {
                write.write(HttpResult.Fail((String)"\u53ea\u652f\u6301\u6307\u4ee4[read\u3001write\u3001writeOfAsync]"));
                return;
            }
            result.setRespTime(System.currentTimeMillis()).setRespMsg(ByteUtil.bytesToHexByFormat((byte[])(respMsg == null ? new byte[]{} : respMsg)));
            if (protocol.getExecStatus() != ExecStatus.success) {
                write.write(HttpResult.StatusCode((Object)result, (String)protocol.getExecStatus().desc, (int)208));
            } else {
                write.write(HttpResult.Success((Object)result));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            write.write(HttpResult.Fail((String)e.getMessage()));
        }
    }

    private void otherHandleforsb(DtuDebugModel model, DebugWebsocketWrite write) {
        String message = model.getMessage();
        if (!StringUtils.hasText((String)message)) {
            write.write(HttpResult.Fail((String)"\u672a\u6307\u5b9a\u8981\u53d1\u9001\u7684\u62a5\u6587"));
            return;
        }
        String cmd = model.getCmd();
        if (!StringUtils.hasText((String)cmd)) {
            write.write(HttpResult.Fail((String)"\u672a\u6307\u5b9a\u64cd\u4f5c\u6307\u4ee4"));
            return;
        }
        try {
            DebugResult result = new DebugResult((DebugModel)model).setDeviceSn(model.getDeviceSn()).setReqTime(System.currentTimeMillis()).setReqMsg(message);
            byte[] respMsg = new byte[]{};
            CommonDtuProtocol protocol = new CommonDtuProtocol(model.getDeviceSn());
            if ("read".equals(cmd)) {
                respMsg = protocol.read(ByteUtil.getBytes((String)message));
            } else if ("write".equals(cmd)) {
                respMsg = protocol.write(ByteUtil.getBytes((String)message));
            } else if ("writeOfAsync".equals(cmd)) {
                protocol.writeOfAsync(ByteUtil.getBytes((String)message));
            } else {
                write.write(HttpResult.Fail((String)"\u53ea\u652f\u6301\u6307\u4ee4[read\u3001write\u3001writeOfAsync]"));
                return;
            }
            result.setRespTime(System.currentTimeMillis()).setRespMsg(ByteUtil.bytesToHexByFormat((byte[])(respMsg == null ? new byte[]{} : respMsg)));
            if (protocol.getExecStatus() != ExecStatus.success) {
                write.write(HttpResult.StatusCode((Object)result, (String)protocol.getExecStatus().desc, (int)208));
            } else {
                write.write(HttpResult.Success((Object)result));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            write.write(HttpResult.Fail((String)e.getMessage()));
        }
    }

    private void modbusTcpHandle(DtuDebugModel model, DebugWebsocketWrite write) {
        ModbusTcpForDtuCommonProtocol protocol;
        if (StringUtils.hasText((String)model.getMessage())) {
            try {
                byte[] bytes = ByteUtil.hexToByte((String)model.getMessage());
                protocol = ModbusTcpForDtuCommonProtocol.build((String)model.getDeviceSn(), (byte[])bytes, null);
            }
            catch (Exception e) {
                write.write(HttpResult.Fail((String)"\u62a5\u6587\u53ea\u652f\u6301\u5341\u516d\u8fdb\u5236\u683c\u5f0f"));
                return;
            }
        } else {
            if (!this.modbusValidate(model, write)) {
                return;
            }
            String cmd = model.getCmd();
            Integer address = Integer.valueOf(model.getChildSn());
            switch (cmd) {
                case "01": {
                    protocol = ModbusTcpForDtuCommonProtocol.buildRead01((String)model.getDeviceSn(), (int)address, (int)model.getStart(), (int)this.getTypeCoilNum(model));
                    break;
                }
                case "02": {
                    protocol = ModbusTcpForDtuCommonProtocol.buildRead02((String)model.getDeviceSn(), (int)address, (int)model.getStart(), (int)this.getTypeCoilNum(model));
                    break;
                }
                case "03": {
                    protocol = ModbusTcpForDtuCommonProtocol.buildRead03((String)model.getDeviceSn(), (int)address, (int)model.getStart(), (int)this.getTypeCoilNum(model));
                    break;
                }
                case "04": {
                    protocol = ModbusTcpForDtuCommonProtocol.buildRead04((String)model.getDeviceSn(), (int)address, (int)model.getStart(), (int)this.getTypeCoilNum(model));
                    break;
                }
                case "05": {
                    Object writeValue = this.parseWriteValue(model);
                    if (writeValue == null) {
                        write.write(HttpResult.Fail((String)"\u519905\u529f\u80fd\u7801\u7684\u503c\u53ea\u80fd\u662f[0 \u6216 1]"));
                        return;
                    }
                    protocol = ModbusTcpForDtuCommonProtocol.buildWrite05((String)model.getDeviceSn(), (int)address, (int)model.getStart(), (ModbusCoilStatus)((ModbusCoilStatus)writeValue));
                    break;
                }
                case "06": {
                    protocol = ModbusTcpForDtuCommonProtocol.buildWrite06((String)model.getDeviceSn(), (int)address, (int)model.getStart(), (byte[])((byte[])this.parseWriteValue(model)));
                    break;
                }
                case "10": {
                    byte[] writeBytes = (byte[])this.parseWriteValue(model);
                    protocol = ModbusTcpForDtuCommonProtocol.buildWrite10((String)model.getDeviceSn(), (int)address, (int)model.getStart(), (int)(writeBytes.length / 2), (byte[])writeBytes);
                    break;
                }
                case "0F": {
                    protocol = ModbusTcpForDtuCommonProtocol.buildWrite0F((String)model.getDeviceSn(), (int)address, (int)model.getStart(), (byte[])((byte[])this.parseWriteValue(model)));
                    break;
                }
                default: {
                    write.write(HttpResult.Fail((String)("\u4e0d\u652f\u6301\u7684\u6307\u4ee4[" + cmd + "]")));
                    return;
                }
            }
        }
        this.sendProtocolRequest(model, write, (ServerInitiativeProtocol)protocol);
    }

    private boolean modbusValidate(DtuDebugModel model, DebugWebsocketWrite write) {
        if (model.getStart() == null) {
            write.write(HttpResult.Fail((String)"\u672a\u6307\u5b9a\u5bc4\u5b58\u5668\u8d77\u59cb\u5730\u5740"));
            return false;
        }
        if (!StringUtils.hasText((String)model.getCmd())) {
            write.write(HttpResult.Fail((String)"\u672a\u6307\u5b9a\u529f\u80fd\u7801\u6307\u4ee4"));
            return false;
        }
        if (!StringUtils.hasText((String)model.getType())) {
            write.write(HttpResult.Fail((String)"\u672a\u6307\u5b9a\u503c\u7c7b\u578b"));
            return false;
        }
        return true;
    }

    private void modbusRtuHandle(@NotNull DtuDebugModel model, DebugWebsocketWrite write) {
        ModbusRtuForDtuCommonProtocol protocol;
        if (StringUtils.hasText((String)model.getMessage())) {
            try {
                String hexMsg = model.getMessage().replaceAll(" ", "");
                byte[] bytes = ByteUtil.hexToByte((String)hexMsg);
                protocol = ModbusRtuForDtuCommonProtocol.build((String)model.getDeviceSn(), (byte[])bytes, null);
            }
            catch (Exception e) {
                write.write(HttpResult.Fail((String)"\u62a5\u6587\u53ea\u652f\u6301\u5341\u516d\u8fdb\u5236\u683c\u5f0f"));
                return;
            }
        } else {
            if (!this.modbusValidate(model, write)) {
                return;
            }
            String cmd = model.getCmd();
            Integer address = Integer.valueOf(model.getChildSn());
            switch (cmd) {
                case "01": {
                    protocol = ModbusRtuForDtuCommonProtocol.buildRead01((String)model.getDeviceSn(), (int)address, (int)model.getStart(), (int)this.getTypeCoilNum(model));
                    break;
                }
                case "02": {
                    protocol = ModbusRtuForDtuCommonProtocol.buildRead02((String)model.getDeviceSn(), (int)address, (int)model.getStart(), (int)this.getTypeCoilNum(model));
                    break;
                }
                case "03": {
                    protocol = ModbusRtuForDtuCommonProtocol.buildRead03((String)model.getDeviceSn(), (int)address, (int)model.getStart(), (int)this.getTypeCoilNum(model));
                    break;
                }
                case "04": {
                    protocol = ModbusRtuForDtuCommonProtocol.buildRead04((String)model.getDeviceSn(), (int)address, (int)model.getStart(), (int)this.getTypeCoilNum(model));
                    break;
                }
                case "05": {
                    Object writeValue = this.parseWriteValue(model);
                    if (writeValue == null) {
                        write.write(HttpResult.Fail((String)"\u519905\u529f\u80fd\u7801\u7684\u503c\u53ea\u80fd\u662f[0 \u6216 1]"));
                        return;
                    }
                    protocol = ModbusRtuForDtuCommonProtocol.buildWrite05((String)model.getDeviceSn(), (int)address, (int)model.getStart(), (ModbusCoilStatus)((ModbusCoilStatus)writeValue));
                    break;
                }
                case "06": {
                    protocol = ModbusRtuForDtuCommonProtocol.buildWrite06((String)model.getDeviceSn(), (int)address, (int)model.getStart(), (byte[])((byte[])this.parseWriteValue(model)));
                    break;
                }
                case "10": {
                    byte[] writeBytes = (byte[])this.parseWriteValue(model);
                    protocol = ModbusRtuForDtuCommonProtocol.buildWrite10((String)model.getDeviceSn(), (int)address, (int)model.getStart(), (int)(writeBytes.length / 2), (byte[])writeBytes);
                    break;
                }
                case "0F": {
                    protocol = ModbusRtuForDtuCommonProtocol.buildWrite0F((String)model.getDeviceSn(), (int)address, (int)model.getStart(), (byte[])((byte[])this.parseWriteValue(model)));
                    break;
                }
                default: {
                    write.write(HttpResult.Fail((String)("\u4e0d\u652f\u6301\u7684\u6307\u4ee4[" + cmd + "]")));
                    return;
                }
            }
        }
        this.sendProtocolRequest(model, write, (ServerInitiativeProtocol)protocol);
    }

    private int getTypeCoilNum(DtuDebugModel model) {
        String type;
        switch (type = model.getType()) {
            case "int": 
            case "float": 
            case "UInt": 
            case "LONG": 
            case "real4": 
            case "origin": {
                return 2;
            }
            case "double": 
            case "long": {
                return 4;
            }
            case "short": 
            case "boolean": 
            case "UShort": {
                return 1;
            }
            case "string": {
                String writeValue = model.getWriteValue();
                if (!StringUtils.hasText((String)writeValue)) {
                    throw new IllegalArgumentException("\u672a\u6307\u5b9a\u8981\u8bfb\u53d6\u5b57\u7b26\u4e32\u7684\u957f\u5ea6");
                }
                try {
                    return Integer.valueOf(writeValue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u7684\u957f\u5ea6\u503c[" + writeValue + "]\u4e0d\u652f\u6301");
                }
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u503c\u7c7b\u578b[" + type + "]");
    }

    private void sendProtocolRequest(DtuDebugModel model, DebugWebsocketWrite write, ServerInitiativeProtocol protocol) {
        try {
            DebugResult result = new DebugResult((DebugModel)model).setReqTime(System.currentTimeMillis());
            protocol.request(protocol1 -> {
                ServerMessage serverMessage;
                result.setDeviceSn(model.getDeviceSn());
                result.setRespTime(System.currentTimeMillis());
                if (protocol.requestMessage().getMessage() != null) {
                    result.setReqMsg(ByteUtil.bytesToHexByFormat((byte[])protocol.requestMessage().getMessage()));
                }
                if ((serverMessage = protocol.responseMessage()) != null) {
                    result.setRespMsg(ByteUtil.bytesToHexByFormat((byte[])serverMessage.getMessage()));
                }
                if (protocol.getExecStatus() == ExecStatus.success) {
                    Payload payload;
                    Message.MessageBody body = serverMessage.getBody();
                    if (body instanceof ModbusRtuBody) {
                        if (!((ModbusRtuBody)body).isSuccess()) {
                            String reason = ((ModbusRtuBody)body).getErrCode().getDesc();
                            write.write(HttpResult.StatusCode((Object)result, (String)reason, (int)208));
                            return null;
                        }
                    } else if (body instanceof ModbusTcpBody && !((ModbusTcpBody)body).isSuccess()) {
                        String reason = ((ModbusTcpBody)body).getErrCode().getDesc();
                        write.write(HttpResult.StatusCode((Object)result, (String)reason, (int)208));
                        return null;
                    }
                    if ((payload = ((ModbusCommonProtocol)protocol).getPayload()) instanceof ReadPayload) {
                        result.setValue((Object)this.parseReadValue(model, payload).toString());
                    } else if (payload instanceof RealCoilPayload) {
                        result.setValue((Object)payload.readStatus(0).getBit());
                    } else {
                        result.setValue((Object)model.getWriteValue());
                    }
                    write.write(HttpResult.Success((Object)result));
                } else if (protocol.getExecStatus() == ExecStatus.offline) {
                    write.write(HttpResult.StatusCode((Object)result, (String)protocol.getExecStatus().desc, (int)208));
                } else {
                    write.write(HttpResult.StatusCode((Object)result, (String)protocol.getExecStatus().desc, (int)208));
                }
                return null;
            });
        }
        catch (ProtocolException e) {
            e.printStackTrace();
            write.write(HttpResult.Fail((String)e.getMessage()));
        }
    }

    public static byte[] byteReverse(byte[] a) {
        byte temp = a[0];
        a[0] = a[2];
        a[2] = temp;
        temp = a[1];
        a[1] = a[3];
        a[3] = temp;
        return a;
    }

    public static int bytesToInt(byte[] src, int offset) {
        int value = src[offset] & 0xFF | (src[offset + 1] & 0xFF) << 8 | (src[offset + 2] & 0xFF) << 16 | (src[offset + 3] & 0xFF) << 24;
        return value;
    }

    public static int bytesToInt2(byte[] src, int offset) {
        DtuDebugHandle.byteReverse((byte[])src);
        int value = (src[offset] & 0xFF) << 24 | (src[offset + 1] & 0xFF) << 16 | (src[offset + 2] & 0xFF) << 8 | src[offset + 3] & 0xFF;
        return value;
    }

    public static String byteArrayToHexStr(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[byteArray.length * 2];
        for (int j = 0; j < byteArray.length; ++j) {
            int v = byteArray[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static long longFrom8Bytes(byte[] input, int offset, boolean littleEndian) {
        long value = 0L;
        for (int count = 0; count < 8; ++count) {
            int shift = (littleEndian ? count : 7 - count) << 3;
            value |= 255L << shift & (long)input[offset + count] << shift;
        }
        return value;
    }

    public static int byteArrayToIntIgnoreSign(byte[] bytes) {
        return (bytes[0] & 0xFF) + ((bytes[1] & 0xFF) << 8) + ((bytes[2] & 0xFF) << 16) + ((bytes[3] & 0xFF) << 24);
    }

    private Object parseReadValue(DtuDebugModel model, Payload payload) {
        String type = model.getType();
        System.out.println("parseReadValue");
        switch (type) {
            case "int": {
                return payload.readInt(model.getStart().intValue());
            }
            case "float": {
                return Float.valueOf(payload.readFloat(model.getStart().intValue()));
            }
            case "real4": {
                ByteBuffer buf = ByteBuffer.allocateDirect(4);
                buf.put(DtuDebugHandle.byteReverse((byte[])payload.getPayload()));
                buf.rewind();
                return Float.valueOf(buf.getFloat());
            }
            case "origin": {
                return Hex2Float.bytes2BinaryStr((byte[])payload.getPayload());
            }
            case "double": {
                return payload.readDouble(model.getStart().intValue());
            }
            case "short": {
                return payload.readShort(model.getStart().intValue());
            }
            case "long": {
                return payload.readLong(model.getStart().intValue());
            }
            case "UInt": {
                return payload.readUInt(model.getStart().intValue());
            }
            case "UShort": {
                return payload.readUShort(model.getStart().intValue());
            }
            case "LONG": {
                ByteBuffer buff = ByteBuffer.allocateDirect(4);
                buff.put(DtuDebugHandle.byteReverse((byte[])payload.getPayload()));
                buff.rewind();
                return buff.getInt();
            }
            case "boolean": {
                return model.getWriteValue().equals("0") ? ModbusCoilStatus.OFF : (model.getWriteValue().equals("1") ? ModbusCoilStatus.ON : null);
            }
            case "string": {
                int length = Integer.valueOf(model.getWriteValue());
                return payload.readString(model.getStart().intValue(), length);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u503c\u7c7b\u578b[" + type + "]");
    }

    private Object parseWriteValue(DtuDebugModel model) {
        String type = model.getType();
        if (!StringUtils.hasText((String)model.getWriteValue())) {
            throw new IllegalArgumentException("\u4e3a\u6307\u5b9a\u8981\u5199\u7684\u503c");
        }
        System.out.println("parseWriteValue");
        try {
            switch (type) {
                case "UInt": 
                case "UShort": 
                case "LONG": 
                case "real4": {
                    return ByteUtil.getBytesOfReverse((int)Integer.valueOf(model.getWriteValue()));
                }
                case "origin": {
                    return ByteUtil.getBytes((String)model.getWriteValue());
                }
                case "int": {
                    return ByteUtil.getBytes((int)Integer.valueOf(model.getWriteValue()));
                }
                case "float": {
                    return ByteUtil.getBytes((float)Float.valueOf(model.getWriteValue()).floatValue());
                }
                case "double": {
                    return ByteUtil.getBytes((double)Double.valueOf(model.getWriteValue()));
                }
                case "short": {
                    return ByteUtil.getBytesOfReverse((short)Short.valueOf(model.getWriteValue()));
                }
                case "long": {
                    return ByteUtil.getBytes((long)Long.valueOf(model.getWriteValue()));
                }
                case "boolean": {
                    return model.getWriteValue().equals("0") ? ModbusCoilStatus.OFF : (model.getWriteValue().equals("1") ? ModbusCoilStatus.ON : null);
                }
                case "string": {
                    return model.getWriteValue().getBytes(StandardCharsets.UTF_8);
                }
            }
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u503c\u7c7b\u578b[" + type + "]");
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("\u503c\u7c7b\u578b[" + type + "]\u548c\u503c[" + model.getWriteValue() + "]\u4e0d\u5339\u914d");
        }
    }
}

