/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.debug.modbus;

import com.iteaj.framework.result.HttpResult;
import com.iteaj.iboot.msn.iot.debug.DebugHandle;
import com.iteaj.iboot.msn.iot.debug.DebugModel;
import com.iteaj.iboot.msn.iot.debug.DebugResult;
import com.iteaj.iboot.msn.iot.debug.DebugWebsocketWrite;
import com.iteaj.iboot.msn.iot.debug.modbus.ModbusDebugModel;
import com.iteaj.iboot.msn.iot.rtu.ModbusRtuClientCommonProtocol;
import com.iteaj.iot.Message;
import com.iteaj.iot.ProtocolException;
import com.iteaj.iot.client.ClientConnectProperties;
import com.iteaj.iot.client.ClientMessage;
import com.iteaj.iot.client.protocol.ClientInitiativeProtocol;
import com.iteaj.iot.consts.ExecStatus;
import com.iteaj.iot.modbus.ModbusCommonProtocol;
import com.iteaj.iot.modbus.Payload;
import com.iteaj.iot.modbus.ReadPayload;
import com.iteaj.iot.modbus.RealCoilPayload;
import com.iteaj.iot.modbus.client.tcp.ModbusTcpClientCommonProtocol;
import com.iteaj.iot.modbus.consts.ModbusCoilStatus;
import com.iteaj.iot.modbus.server.rtu.ModbusRtuBody;
import com.iteaj.iot.modbus.server.tcp.ModbusTcpBody;
import com.iteaj.iot.modbus.server.tcp.ModbusTcpHeader;
import com.iteaj.iot.serial.SerialConnectProperties;
import com.iteaj.iot.utils.ByteUtil;
import java.nio.charset.StandardCharsets;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ModbusDebugHandle
implements DebugHandle<ModbusDebugModel> {
    public String type() {
        return "modbus";
    }

    public void handle(ModbusDebugModel model, DebugWebsocketWrite write) {
        String deviceSn = model.getDeviceSn();
        if (!StringUtils.hasText((String)deviceSn)) {
            write.write(HttpResult.Fail((String)"\u672a\u6307\u5b9a\u8bbe\u5907\u7f16\u53f7[deviceSn]"));
            return;
        }
        try {
            String protocolType = model.getProtocolType();
            if (!StringUtils.hasText((String)protocolType)) {
                write.write(HttpResult.Fail((String)"\u8bf7\u6307\u5b9a\u534f\u8bae\u7c7b\u578b[protocolType]"));
            } else {
                switch (protocolType) {
                    case "tcp": {
                        this.modbusTcpHandle(model, write);
                        break;
                    }
                    case "rtu": {
                        this.modbusRtuHandle(model, write);
                        break;
                    }
                    default: {
                        write.write(HttpResult.Fail((String)("\u4e0d\u652f\u6301\u7684\u534f\u8bae\u7c7b\u578b[" + protocolType + "]")));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            write.write(HttpResult.Fail((String)e.getMessage()));
        }
    }

    private void modbusTcpHandle(ModbusDebugModel model, DebugWebsocketWrite write) {
        ModbusTcpClientCommonProtocol protocol;
        if (StringUtils.hasText((String)model.getMessage())) {
            try {
                String hexMsg = model.getMessage().replaceAll(" ", "");
                byte[] bytes = ByteUtil.hexToByte((String)hexMsg);
                ModbusTcpBody empty = ModbusTcpBody.empty();
                ModbusTcpHeader header = ModbusTcpHeader.buildRequestHeader(null, null, null);
                header.setMessage(bytes);
                protocol = ModbusTcpClientCommonProtocol.build((ModbusTcpHeader)header, (ModbusTcpBody)empty);
            }
            catch (Exception e) {
                write.write(HttpResult.Fail((String)"\u62a5\u6587\u53ea\u652f\u6301\u5341\u516d\u8fdb\u5236\u683c\u5f0f"));
                return;
            }
        } else {
            if (!this.modbusValidate(model, write)) {
                return;
            }
            String cmd = model.getCmd();
            Integer address = Integer.valueOf(model.getChildSn());
            switch (cmd) {
                case "01": {
                    protocol = ModbusTcpClientCommonProtocol.buildRead01((int)address, (int)model.getStart(), (int)this.getTypeCoilNum(model));
                    break;
                }
                case "02": {
                    protocol = ModbusTcpClientCommonProtocol.buildRead02((int)address, (int)model.getStart(), (int)this.getTypeCoilNum(model));
                    break;
                }
                case "03": {
                    protocol = ModbusTcpClientCommonProtocol.buildRead03((int)address, (int)model.getStart(), (int)this.getTypeCoilNum(model));
                    break;
                }
                case "04": {
                    protocol = ModbusTcpClientCommonProtocol.buildRead04((int)address, (int)model.getStart(), (int)this.getTypeCoilNum(model));
                    break;
                }
                case "05": {
                    Object writeValue = this.parseWriteValue(model);
                    if (writeValue == null) {
                        write.write(HttpResult.Fail((String)"\u519905\u529f\u80fd\u7801\u7684\u503c\u53ea\u80fd\u662f[0 \u6216 1]"));
                        return;
                    }
                    protocol = ModbusTcpClientCommonProtocol.buildWrite05((int)address, (int)model.getStart(), (ModbusCoilStatus)((ModbusCoilStatus)writeValue));
                    break;
                }
                case "06": {
                    protocol = ModbusTcpClientCommonProtocol.buildWrite06((int)address, (int)model.getStart(), (byte[])((byte[])this.parseWriteValue(model)));
                    break;
                }
                case "10": {
                    byte[] writeBytes = (byte[])this.parseWriteValue(model);
                    protocol = ModbusTcpClientCommonProtocol.buildWrite10((int)address, (int)model.getStart(), (int)(writeBytes.length / 2), (byte[])writeBytes);
                    break;
                }
                case "0F": {
                    protocol = ModbusTcpClientCommonProtocol.buildWrite0F((int)address, (int)model.getStart(), (byte[])((byte[])this.parseWriteValue(model)));
                    break;
                }
                default: {
                    write.write(HttpResult.Fail((String)("\u4e0d\u652f\u6301\u7684\u6307\u4ee4[" + cmd + "]")));
                    return;
                }
            }
        }
        ClientConnectProperties properties = new ClientConnectProperties(model.getHost(), model.getPort());
        protocol.setClientKey(properties);
        this.sendProtocolRequest(model, write, (ClientInitiativeProtocol)protocol);
    }

    private boolean modbusValidate(ModbusDebugModel model, DebugWebsocketWrite write) {
        if (model.getStart() == null) {
            write.write(HttpResult.Fail((String)"\u672a\u6307\u5b9a\u5bc4\u5b58\u5668\u8d77\u59cb\u5730\u5740"));
            return false;
        }
        if (!StringUtils.hasText((String)model.getCmd())) {
            write.write(HttpResult.Fail((String)"\u672a\u6307\u5b9a\u529f\u80fd\u7801\u6307\u4ee4"));
            return false;
        }
        if (!StringUtils.hasText((String)model.getType())) {
            write.write(HttpResult.Fail((String)"\u672a\u6307\u5b9a\u503c\u7c7b\u578b"));
            return false;
        }
        return true;
    }

    private void modbusRtuHandle(ModbusDebugModel model, DebugWebsocketWrite write) {
        ModbusRtuClientCommonProtocol protocol;
        block27: {
            protocol = null;
            if (StringUtils.hasText((String)model.getMessage())) {
                try {
                    try {
                        String hexMsg = model.getMessage().replaceAll(" ", "");
                        byte[] bytes = ByteUtil.hexToByte((String)hexMsg);
                        protocol = ModbusRtuClientCommonProtocol.build((byte[])bytes);
                        break block27;
                    }
                    catch (Exception e) {
                        write.write(HttpResult.Fail((String)"\u62a5\u6587\u53ea\u652f\u6301\u5341\u516d\u8fdb\u5236\u683c\u5f0f"));
                        return;
                    }
                }
                catch (Exception e) {
                    write.write(HttpResult.Fail((String)"\u62a5\u6587\u53ea\u652f\u6301\u5341\u516d\u8fdb\u5236\u683c\u5f0f"));
                    return;
                }
            }
            if (!this.modbusValidate(model, write)) {
                return;
            }
            String cmd = model.getCmd();
            Integer address = Integer.valueOf(model.getChildSn());
            switch (cmd) {
                case "01": {
                    protocol = ModbusRtuClientCommonProtocol.buildRead01((int)address, (int)model.getStart(), (int)this.getTypeCoilNum(model));
                    break;
                }
                case "02": {
                    protocol = ModbusRtuClientCommonProtocol.buildRead02((int)address, (int)model.getStart(), (int)this.getTypeCoilNum(model));
                    break;
                }
                case "03": {
                    protocol = ModbusRtuClientCommonProtocol.buildRead03((int)address, (int)model.getStart(), (int)this.getTypeCoilNum(model));
                    break;
                }
                case "04": {
                    protocol = ModbusRtuClientCommonProtocol.buildRead04((int)address, (int)model.getStart(), (int)this.getTypeCoilNum(model));
                    break;
                }
                case "05": {
                    Object writeValue = this.parseWriteValue(model);
                    if (writeValue == null) {
                        write.write(HttpResult.Fail((String)"\u519905\u529f\u80fd\u7801\u7684\u503c\u53ea\u80fd\u662f[0 \u6216 1]"));
                        return;
                    }
                    protocol = ModbusRtuClientCommonProtocol.buildWrite05((int)address, (int)model.getStart(), (ModbusCoilStatus)((ModbusCoilStatus)writeValue));
                    break;
                }
                case "06": {
                    protocol = ModbusRtuClientCommonProtocol.buildWrite06((int)address, (int)model.getStart(), (byte[])((byte[])this.parseWriteValue(model)));
                    break;
                }
                case "10": {
                    byte[] writeBytes = (byte[])this.parseWriteValue(model);
                    protocol = ModbusRtuClientCommonProtocol.buildWrite10((int)address, (int)model.getStart(), (int)(writeBytes.length / 2), (byte[])writeBytes);
                    break;
                }
                case "0F": {
                    protocol = ModbusRtuClientCommonProtocol.buildWrite0F((int)address, (int)model.getStart(), (byte[])((byte[])this.parseWriteValue(model)));
                    break;
                }
                default: {
                    write.write(HttpResult.Fail((String)("\u4e0d\u652f\u6301\u7684\u6307\u4ee4[" + cmd + "]")));
                    return;
                }
            }
        }
        SerialConnectProperties config = new SerialConnectProperties(model.getDeviceSn(), model.getBaudRate().intValue()).config(model.getDataBits().intValue(), model.getStopBits().intValue(), model.getParity().intValue());
        protocol.setClientKey((ClientConnectProperties)config);
        this.sendProtocolRequest(model, write, (ClientInitiativeProtocol)protocol);
    }

    private int getTypeCoilNum(ModbusDebugModel model) {
        String type;
        switch (type = model.getType()) {
            case "int": 
            case "float": 
            case "UInt": 
            case "LONG": 
            case "real4": 
            case "origin": {
                return 2;
            }
            case "double": 
            case "long": {
                return 4;
            }
            case "short": 
            case "boolean": 
            case "UShort": {
                return 1;
            }
            case "string": {
                String writeValue = model.getWriteValue();
                if (!StringUtils.hasText((String)writeValue)) {
                    throw new IllegalArgumentException("\u672a\u6307\u5b9a\u8981\u8bfb\u53d6\u5b57\u7b26\u4e32\u7684\u957f\u5ea6");
                }
                try {
                    return Integer.valueOf(writeValue);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("\u5b57\u7b26\u4e32\u7684\u957f\u5ea6\u503c[" + writeValue + "]\u4e0d\u652f\u6301");
                }
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u503c\u7c7b\u578b[" + type + "]");
    }

    private void sendProtocolRequest(ModbusDebugModel model, DebugWebsocketWrite write, ClientInitiativeProtocol protocol) {
        try {
            DebugResult result = new DebugResult((DebugModel)model).setReqTime(System.currentTimeMillis());
            protocol.request(protocol1 -> {
                ClientMessage clientMessage;
                result.setDeviceSn(model.getDeviceSn());
                result.setRespTime(System.currentTimeMillis());
                if (protocol.requestMessage().getMessage() != null) {
                    result.setReqMsg(ByteUtil.bytesToHexByFormat((byte[])protocol.requestMessage().getMessage()));
                }
                if ((clientMessage = protocol.responseMessage()) != null) {
                    result.setRespMsg(ByteUtil.bytesToHexByFormat((byte[])clientMessage.getMessage()));
                }
                if (protocol.getExecStatus() == ExecStatus.success) {
                    Payload payload;
                    Message.MessageBody body = clientMessage.getBody();
                    if (body instanceof ModbusRtuBody) {
                        if (!((ModbusRtuBody)body).isSuccess()) {
                            String reason = ((ModbusRtuBody)body).getErrCode().getDesc();
                            write.write(HttpResult.StatusCode((Object)result, (String)reason, (int)208));
                            return null;
                        }
                    } else if (body instanceof ModbusTcpBody && !((ModbusTcpBody)body).isSuccess()) {
                        String reason = ((ModbusTcpBody)body).getErrCode().getDesc();
                        write.write(HttpResult.StatusCode((Object)result, (String)reason, (int)208));
                        return null;
                    }
                    if ((payload = ((ModbusCommonProtocol)protocol).getPayload()) instanceof ReadPayload) {
                        result.setValue((Object)this.parseReadValue(model, payload).toString());
                    } else if (payload instanceof RealCoilPayload) {
                        result.setValue((Object)payload.readStatus(0).getBit());
                    } else {
                        result.setValue((Object)model.getWriteValue());
                    }
                    write.write(HttpResult.Success((Object)result));
                } else if (protocol.getExecStatus() == ExecStatus.offline) {
                    write.write(HttpResult.StatusCode((Object)result, (String)protocol.getExecStatus().desc, (int)208));
                } else {
                    write.write(HttpResult.StatusCode((Object)result, (String)protocol.getExecStatus().desc, (int)208));
                }
                return null;
            });
        }
        catch (ProtocolException e) {
            e.printStackTrace();
            write.write(HttpResult.Fail((String)e.getMessage()));
        }
    }

    private Object parseReadValue(ModbusDebugModel model, Payload payload) {
        String type;
        System.out.println("Object parseReadValue(ModbusDebugModel model, Payload payload) ");
        switch (type = model.getType()) {
            case "int": {
                return payload.readInt(model.getStart().intValue());
            }
            case "float": {
                return Float.valueOf(payload.readFloat(model.getStart().intValue()));
            }
            case "double": {
                return payload.readDouble(model.getStart().intValue());
            }
            case "short": {
                return payload.readShort(model.getStart().intValue());
            }
            case "long": {
                return payload.readLong(model.getStart().intValue());
            }
            case "string": {
                int length = Integer.valueOf(model.getWriteValue());
                return payload.readString(model.getStart().intValue(), length);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u503c\u7c7b\u578b[" + type + "]");
    }

    private Object parseWriteValue(ModbusDebugModel model) {
        String type = model.getType();
        if (!StringUtils.hasText((String)model.getWriteValue())) {
            throw new IllegalArgumentException("\u4e3a\u6307\u5b9a\u8981\u5199\u7684\u503c");
        }
        try {
            switch (type) {
                case "int": {
                    return ByteUtil.getBytes((int)Integer.valueOf(model.getWriteValue()));
                }
                case "float": {
                    return ByteUtil.getBytes((float)Float.valueOf(model.getWriteValue()).floatValue());
                }
                case "double": {
                    return ByteUtil.getBytes((double)Double.valueOf(model.getWriteValue()));
                }
                case "short": {
                    return ByteUtil.getBytesOfReverse((short)Short.valueOf(model.getWriteValue()));
                }
                case "long": {
                    return ByteUtil.getBytes((long)Long.valueOf(model.getWriteValue()));
                }
                case "boolean": {
                    return model.getWriteValue().equals("0") ? ModbusCoilStatus.OFF : (model.getWriteValue().equals("1") ? ModbusCoilStatus.ON : null);
                }
                case "string": {
                    return model.getWriteValue().getBytes(StandardCharsets.UTF_8);
                }
            }
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u503c\u7c7b\u578b[" + type + "]");
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("\u503c\u7c7b\u578b[" + type + "]\u548c\u503c[" + model.getWriteValue() + "]\u4e0d\u5339\u914d");
        }
    }
}

