/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.iot.debug.plc;

import com.iteaj.framework.result.HttpResult;
import com.iteaj.iboot.msn.iot.debug.DebugHandle;
import com.iteaj.iboot.msn.iot.debug.DebugModel;
import com.iteaj.iboot.msn.iot.debug.DebugResult;
import com.iteaj.iboot.msn.iot.debug.DebugWebsocketWrite;
import com.iteaj.iboot.msn.iot.debug.plc.PlcDebugModel;
import com.iteaj.iot.client.ClientConnectProperties;
import com.iteaj.iot.consts.ExecStatus;
import com.iteaj.iot.plc.omron.OmronConnectProperties;
import com.iteaj.iot.plc.omron.OmronTcpProtocol;
import com.iteaj.iot.plc.siemens.SiemensConnectProperties;
import com.iteaj.iot.plc.siemens.SiemensModel;
import com.iteaj.iot.plc.siemens.SiemensS7Protocol;
import com.iteaj.iot.utils.ByteUtil;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PlcDebugHandle
implements DebugHandle<PlcDebugModel> {
    public String type() {
        return "plc";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(PlcDebugModel model, DebugWebsocketWrite write) {
        if (!StringUtils.hasText((String)model.getIp()) || model.getPort() == null) {
            write.write(HttpResult.Fail((String)"\u672a\u6307\u5b9aplc\u8bbe\u5907\u7684ip\u5730\u5740\u548c\u7aef\u53e3"));
            return;
        }
        OmronTcpProtocol plcClientProtocol = null;
        if (model.getPlcType() == 2) {
            try {
                SiemensModel siemensModel = SiemensModel.valueOf((String)model.getModel());
                plcClientProtocol = new SiemensS7Protocol((ClientConnectProperties)new SiemensConnectProperties(model.getIp(), model.getPort(), siemensModel));
            }
            catch (Exception e) {
                e.printStackTrace();
                write.write(HttpResult.Fail((String)("\u4e0d\u652f\u6301\u897f\u95e8\u5b50\u578b\u53f7[" + model.getModel() + "]")));
                return;
            }
        } else {
            if (model.getPlcType() != 3) {
                write.write(HttpResult.Fail((String)("\u4e0d\u652f\u6301\u7684plc\u7c7b\u578b[" + model.getPlcType() + "]")));
                return;
            }
            plcClientProtocol = new OmronTcpProtocol(new OmronConnectProperties(model.getIp(), model.getPort()));
        }
        Object readValue = model.getValue();
        DebugResult result = new DebugResult((DebugModel)model).setDeviceSn(model.getDeviceSn()).setReqTime(System.currentTimeMillis());
        try {
            if ("read".equals(model.getCmd())) {
                if (model.getType() == null) {
                    write.write(HttpResult.Fail((String)"\u9519\u8bef\u7684\u6570\u636e\u7c7b\u578b[null]"));
                    return;
                }
                switch (model.getType()) {
                    case "bit": {
                        readValue = plcClientProtocol.readBool(model.getAddress());
                        break;
                    }
                    case "short": {
                        readValue = plcClientProtocol.readInt16(model.getAddress());
                        break;
                    }
                    case "int": {
                        readValue = plcClientProtocol.readInt32(model.getAddress());
                        break;
                    }
                    case "long": {
                        readValue = plcClientProtocol.readInt64(model.getAddress());
                        break;
                    }
                    case "float": {
                        readValue = plcClientProtocol.readFloat(model.getAddress());
                        break;
                    }
                    case "double": {
                        readValue = plcClientProtocol.readDouble(model.getAddress());
                        break;
                    }
                }
            } else if ("write".equals(model.getCmd())) {
                if (model.getType() == null) {
                    write.write(HttpResult.Fail((String)"\u9519\u8bef\u7684\u6570\u636e\u7c7b\u578b[null]"));
                    return;
                }
                switch (model.getType()) {
                    case "bit": {
                        plcClientProtocol.write(model.getAddress(), true);
                        break;
                    }
                    case "short": {
                        plcClientProtocol.write(model.getAddress(), Short.valueOf(model.getValue()).shortValue());
                        break;
                    }
                    case "int": {
                        plcClientProtocol.write(model.getAddress(), Integer.valueOf(model.getValue()).intValue());
                        break;
                    }
                    case "long": {
                        plcClientProtocol.write(model.getAddress(), Long.valueOf(model.getValue()).longValue());
                        break;
                    }
                    case "float": {
                        plcClientProtocol.write(model.getAddress(), Float.valueOf(model.getValue()).floatValue());
                        break;
                    }
                    case "double": {
                        plcClientProtocol.write(model.getAddress(), Double.valueOf(model.getValue()).doubleValue());
                        break;
                    }
                }
            } else {
                if (!"message".equals(model.getCmd())) {
                    write.write(HttpResult.Fail((String)("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u6307\u4ee4[" + model.getCmd() + "]")));
                    return;
                }
                if (!StringUtils.hasText((String)model.getMessage())) {
                    write.write(HttpResult.Fail((String)("\u8bf7\u8f93\u5165\u62a5\u6587[" + model.getMessage() + "]")));
                    return;
                }
                byte[] bytes = ByteUtil.hexToByte((String)model.getMessage().trim());
                byte[] readFull = plcClientProtocol.readFull(bytes);
                readValue = readFull != null ? ByteUtil.bytesToHexByFormat((byte[])readFull) : "";
            }
            result.setValue(readValue).setRespTime(System.currentTimeMillis()).setReqMsg(ByteUtil.bytesToHexByFormat((byte[])plcClientProtocol.requestMessage().getMessage())).setRespMsg(ByteUtil.bytesToHexByFormat((byte[])plcClientProtocol.responseMessage().getMessage()));
            ExecStatus execStatus = plcClientProtocol.getExecStatus();
            if (execStatus != ExecStatus.success) {
                write.write(HttpResult.StatusCode((Object)result, (String)execStatus.desc, (int)208));
                return;
            }
            write.write(HttpResult.Success((Object)result));
            return;
        }
        catch (Exception e) {
            write.write(HttpResult.Fail((String)e.getMessage()));
        }
    }
}

