/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.quartz.jobs;

import java.lang.reflect.Method;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.ReflectionUtils;

public class QuartzJobContext {
    private Object bean;
    private Method method;
    private static ExpressionParser parser = new SpelExpressionParser();

    public QuartzJobContext(Object bean, Method method) {
        this.bean = bean;
        this.method = method;
    }

    public Object invoke(String expression, JobExecutionContext jobExecutionContext) {
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Object[] params = new Object[parameterTypes.length];
        if (parameterTypes.length > 0) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                params[i] = JobDataMap.class.isAssignableFrom(parameterTypes[i]) ? jobDataMap : (JobExecutionContext.class.isAssignableFrom(parameterTypes[i]) ? jobExecutionContext : null);
            }
        }
        return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.bean, (Object[])params);
    }

    public Object getBean() {
        return this.bean;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuartzJobContext)) {
            return false;
        }
        QuartzJobContext other = (QuartzJobContext)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Object this$bean = this.getBean();
        Object other$bean = other.getBean();
        if (this$bean == null ? other$bean != null : !this$bean.equals(other$bean)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        return !(this$method == null ? other$method != null : !((Object)this$method).equals(other$method));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QuartzJobContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $bean = this.getBean();
        result = result * 59 + ($bean == null ? 43 : $bean.hashCode());
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        return result;
    }

    public String toString() {
        return "QuartzJobContext(bean=" + this.getBean() + ", method=" + this.getMethod() + ")";
    }
}

