/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.quartz.scheduler;

import com.iteaj.iboot.msn.quartz.jobs.SpringSupportJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class SchedulerManager {
    private final Scheduler scheduler;
    private final String JOB_GROUP_NAME;
    private final String TRIGGER_GROUP_NAME;

    public SchedulerManager(Scheduler scheduler, String JOB_GROUP_NAME, String TRIGGER_GROUP_NAME) {
        this.scheduler = scheduler;
        this.JOB_GROUP_NAME = JOB_GROUP_NAME;
        this.TRIGGER_GROUP_NAME = TRIGGER_GROUP_NAME;
    }

    public void addJob(String jobName, Class<? extends Job> cls, String cron) {
        this.addJob(jobName, this.JOB_GROUP_NAME, jobName, this.TRIGGER_GROUP_NAME, cls, cron, null, null);
    }

    public void addJob(String jobName, Class<? extends Job> cls, String cron, String desc) {
        this.addJob(jobName, this.JOB_GROUP_NAME, jobName, this.TRIGGER_GROUP_NAME, cls, cron, null, desc);
    }

    public void addJob(String jobName, boolean isConcurrent, String cron, JobDataMap map, String desc) {
        if (!isConcurrent) {
            this.addJob(jobName, this.JOB_GROUP_NAME, jobName, this.TRIGGER_GROUP_NAME, SpringSupportJob.NON_CONCURRENT_EMPTY_JOB, cron, map, desc);
        } else {
            this.addJob(jobName, this.JOB_GROUP_NAME, jobName, this.TRIGGER_GROUP_NAME, SpringSupportJob.EMPTY_JOB, cron, map, desc);
        }
    }

    public void addJob(String jobName, Class<? extends Job> jobClass, String cron, JobDataMap map, String desc) {
        this.addJob(jobName, this.JOB_GROUP_NAME, jobName, this.TRIGGER_GROUP_NAME, jobClass, cron, map, desc);
    }

    protected void addJob(String jobName, String jobGroupName, String triggerName, String triggerGroupName, Class<? extends Job> jobClass, String cron, JobDataMap map, String desc) {
        try {
            JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroupName);
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (jobDetail != null) {
                throw new RuntimeException("\u4f5c\u4e1a\u5df2\u7ecf\u5b58\u5728[" + jobKey + "]");
            }
            map = map == null ? new JobDataMap() : map;
            JobDetail job = JobBuilder.newJob(jobClass).withIdentity(jobName, jobGroupName).usingJobData(map).withDescription(desc).build();
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cron);
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerName, triggerGroupName).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void updateJob(String jobName, boolean isConCurrent, JobDataMap map, String desc) {
        Class jobClass = isConCurrent ? SpringSupportJob.EMPTY_JOB : SpringSupportJob.NON_CONCURRENT_EMPTY_JOB;
        this.updateJob(jobName, jobClass, map, desc);
    }

    public void updateJob(String jobName, Class<? extends Job> jobClass, JobDataMap map, String desc) {
        try {
            JobKey jobKey = new JobKey(jobName, this.JOB_GROUP_NAME);
            JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
            if (jobDetail == null) {
                throw new RuntimeException("\u4f5c\u4e1a\u4e0d\u5b58\u5728[" + jobName + "]");
            }
            JobDetail job = JobBuilder.newJob(jobClass).withIdentity(jobName, this.JOB_GROUP_NAME).usingJobData(map).storeDurably().withDescription(desc).build();
            this.scheduler.addJob(job, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void updateTrigger(String triggerName, String cron) {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)this.TRIGGER_GROUP_NAME);
        try {
            CronTrigger trigger = (CronTrigger)this.scheduler.getTrigger(triggerKey);
            if (trigger == null) {
                throw new RuntimeException("\u89e6\u53d1\u5668\u4e0d\u5b58\u5728[" + triggerKey + "]");
            }
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(cron)) {
                CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cron);
                CronTrigger newTrigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
                this.scheduler.rescheduleJob(triggerKey, (Trigger)newTrigger);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeJob(String jobName) {
        this.resumeJob(jobName, jobName);
    }

    public void removeJob(String jobName, String triggerName) {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)this.TRIGGER_GROUP_NAME);
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)this.JOB_GROUP_NAME);
        try {
            Trigger trigger = this.scheduler.getTrigger(triggerKey);
            if (trigger == null) {
                return;
            }
            this.scheduler.unscheduleJob(triggerKey);
            this.scheduler.deleteJob(jobKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean exists(String jobName) {
        try {
            return this.scheduler.getJobDetail(JobKey.jobKey((String)jobName, (String)this.JOB_GROUP_NAME)) != null;
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    public void pauseJob(String jobName) {
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)this.JOB_GROUP_NAME);
        try {
            this.scheduler.pauseJob(jobKey);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void resumeJob(String jobName) {
        this.resumeJob(jobName, this.JOB_GROUP_NAME);
    }

    protected void resumeJob(String jobName, String jobGroupName) {
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroupName);
        try {
            this.scheduler.resumeJob(jobKey);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void startJobs() {
        try {
            this.scheduler.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void shutdownJobs() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.shutdown();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void fireJob(String jobName) {
        this.fireJob(jobName, this.JOB_GROUP_NAME, null);
    }

    public void fireJob(String jobName, JobDataMap data) {
        this.fireJob(jobName, this.JOB_GROUP_NAME, data);
    }

    protected void fireJob(String jobName, String jobGroupName, JobDataMap data) {
        JobKey jobKey = JobKey.jobKey((String)jobName, (String)jobGroupName);
        try {
            this.scheduler.triggerJob(jobKey, data);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Trigger.TriggerState getTriggerState(String jobName) {
        return this.getTriggerState(jobName, this.TRIGGER_GROUP_NAME);
    }

    protected Trigger.TriggerState getTriggerState(String triggerName, String triggerGroup) {
        TriggerKey triggerKey = TriggerKey.triggerKey((String)triggerName, (String)triggerGroup);
        try {
            return this.scheduler.getTriggerState(triggerKey);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Scheduler getSysScheduler() {
        return this.scheduler;
    }
}

