/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iboot.msn.quartz.service.impl;

import cn.hutool.core.lang.UUID;
import com.alibaba.fastjson.JSONObject;
import com.iteaj.framework.BaseServiceImpl;
import com.iteaj.framework.Entity;
import com.iteaj.framework.exception.ServiceException;
import com.iteaj.framework.result.BooleanResult;
import com.iteaj.iboot.msn.quartz.entity.JobTask;
import com.iteaj.iboot.msn.quartz.mapper.JobTaskMapper;
import com.iteaj.iboot.msn.quartz.scheduler.SchedulerManager;
import com.iteaj.iboot.msn.quartz.service.IJobTaskService;
import java.io.Serializable;
import java.util.Collection;
import org.quartz.JobDataMap;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class JobTaskServiceImpl
extends BaseServiceImpl<JobTaskMapper, JobTask>
implements IJobTaskService {
    private final SchedulerManager schedulerManager;

    public JobTaskServiceImpl(@Qualifier(value="defaultSchedulerManager") SchedulerManager schedulerManager) {
        this.schedulerManager = schedulerManager;
    }

    @Transactional
    public BooleanResult saveOrUpdate(JobTask entity) {
        JobDataMap dataMap = this.getJobDataMap(entity);
        if (entity.getId() != null) {
            this.schedulerManager.updateJob(entity.getJobName(), entity.getConcurrent().booleanValue(), dataMap, entity.getRemark());
        } else {
            String jobName = this.getJobName(entity);
            entity.setJobName(jobName);
            this.schedulerManager.addJob(jobName, entity.getConcurrent().booleanValue(), entity.getCron(), dataMap, entity.getRemark());
        }
        return super.saveOrUpdate((Entity)entity);
    }

    private JobDataMap getJobDataMap(JobTask entity) {
        String args = entity.getParams();
        JobDataMap dataMap = new JobDataMap();
        dataMap.put("METHOD:EXPRESSION", entity.getMethod());
        try {
            if (!StringUtils.hasText((String)args)) {
                return dataMap;
            }
            if (args.startsWith("'") || args.startsWith("\"")) {
                dataMap.put("params", args.substring(1, args.length() - 1));
            } else if (args.startsWith("{")) {
                dataMap.put("params", (Object)JSONObject.parseObject((String)args));
            } else if (args.startsWith("[")) {
                dataMap.put("params", (Object)JSONObject.parseArray((String)args));
            } else {
                dataMap.put("params", args);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u53c2\u6570\u683c\u5f0f\u5316\u5f02\u5e38\uff1a" + args);
        }
        return dataMap;
    }

    private String getJobName(JobTask entity) {
        return UUID.fastUUID().toString(false);
    }

    @Transactional
    public BooleanResult removeByIds(Collection<? extends Serializable> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return BooleanResult.buildFalse((String)"\u8bf7\u6307\u5b9a\u8981\u5220\u9664\u7684\u4f5c\u4e1a");
        }
        this.listByIds(idList).stream().forEach(item -> this.schedulerManager.removeJob(item.getJobName()));
        return super.removeByIds(idList);
    }
}

